/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.immutables.criteria.elasticsearch.Json;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonTest {
    private ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);

    @Test
    public void aggEmpty() throws Exception {
        String json = "{}";
        Json.Aggregations a = (Json.Aggregations)this.mapper.readValue(json, Json.Aggregations.class);
        Assertions.assertNotNull((Object)a);
        MatcherAssert.assertThat((Object)a.asList().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)a.asMap().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void aggSingle1() throws Exception {
        String json = "{agg1: {value: '111'}}";
        Json.Aggregations a = (Json.Aggregations)this.mapper.readValue(json, Json.Aggregations.class);
        Assertions.assertNotNull((Object)a);
        Assertions.assertEquals((int)1, (int)a.asList().size());
        Assertions.assertEquals((int)1, (int)a.asMap().size());
        Assertions.assertEquals((Object)"agg1", (Object)((Json.Aggregation)a.asList().get(0)).getName());
        Assertions.assertEquals((Object)"agg1", a.asMap().keySet().iterator().next());
        Assertions.assertEquals((Object)"111", (Object)((Json.MultiValue)a.asList().get(0)).value());
        ArrayList rows = new ArrayList();
        Json.visitValueNodes((Json.Aggregations)a, rows::add);
        MatcherAssert.assertThat((Object)rows.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(((Map)rows.get(0)).get("agg1"), (Matcher)CoreMatchers.is((Object)"111"));
    }

    @Test
    public void aggMultiValues() throws Exception {
        String json = "{ agg1: {min: 0, max: 2, avg: 2.33}}";
        Json.Aggregations a = (Json.Aggregations)this.mapper.readValue(json, Json.Aggregations.class);
        Assertions.assertNotNull((Object)a);
        Assertions.assertEquals((int)1, (int)a.asList().size());
        Assertions.assertEquals((int)1, (int)a.asMap().size());
        Assertions.assertEquals((Object)"agg1", (Object)((Json.Aggregation)a.asList().get(0)).getName());
        Map values = ((Json.MultiValue)a.get("agg1")).values();
        MatcherAssert.assertThat(values.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"min", "max", "avg"}));
    }

    @Test
    public void aggSingle2() throws Exception {
        String json = "{ agg1: {value: 'foo'}, agg2: {value: 42}}";
        Json.Aggregations a = (Json.Aggregations)this.mapper.readValue(json, Json.Aggregations.class);
        Assertions.assertNotNull((Object)a);
        Assertions.assertEquals((int)2, (int)a.asList().size());
        Assertions.assertEquals((int)2, (int)a.asMap().size());
        MatcherAssert.assertThat(a.asMap().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"agg1", "agg2"}));
    }

    @Test
    public void aggBuckets1() throws Exception {
        String json = "{ groupby: {buckets: [{key:'k1', doc_count:0, myagg:{value: 1.1}}, {key:'k2', myagg:{value: 2.2}}] }}";
        Json.Aggregations a = (Json.Aggregations)this.mapper.readValue(json, Json.Aggregations.class);
        MatcherAssert.assertThat(a.asMap().keySet(), (Matcher)IsCollectionContaining.hasItem((Object)"groupby"));
        MatcherAssert.assertThat((Object)a.get("groupby"), (Matcher)CoreMatchers.instanceOf(Json.MultiBucketsAggregation.class));
        Json.MultiBucketsAggregation multi = (Json.MultiBucketsAggregation)a.get("groupby");
        MatcherAssert.assertThat((Object)multi.buckets().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)multi.getName(), (Matcher)CoreMatchers.is((Object)"groupby"));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(0)).key(), (Matcher)CoreMatchers.is((Object)"k1"));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(0)).keyAsString(), (Matcher)CoreMatchers.is((Object)"k1"));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(1)).key(), (Matcher)CoreMatchers.is((Object)"k2"));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(1)).keyAsString(), (Matcher)CoreMatchers.is((Object)"k2"));
    }

    @Test
    public void aggManyAggregations() throws Exception {
        String json = "{groupby:{buckets:[{key:'k1', a1:{value:1}, a2:{value:2}},{key:'k2', a1:{value:3}, a2:{value:4}}]}}";
        Json.Aggregations a = (Json.Aggregations)this.mapper.readValue(json, Json.Aggregations.class);
        Json.MultiBucketsAggregation multi = (Json.MultiBucketsAggregation)a.get("groupby");
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(0)).getAggregations().asMap().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"groupby"));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(0)).key(), (Matcher)CoreMatchers.is((Object)"k1"));
        MatcherAssert.assertThat(((Json.Bucket)multi.buckets().get(0)).getAggregations().asMap().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"a1", "a2"}));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(1)).getAggregations().asMap().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"groupby"));
        MatcherAssert.assertThat((Object)((Json.Bucket)multi.buckets().get(1)).key(), (Matcher)CoreMatchers.is((Object)"k2"));
        MatcherAssert.assertThat(((Json.Bucket)multi.buckets().get(1)).getAggregations().asMap().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"a1", "a2"}));
        ArrayList rows = new ArrayList();
        Json.visitValueNodes((Json.Aggregations)a, rows::add);
        MatcherAssert.assertThat((Object)rows.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(((Map)rows.get(0)).get("groupby"), (Matcher)CoreMatchers.is((Object)"k1"));
        MatcherAssert.assertThat(((Map)rows.get(0)).get("a1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(((Map)rows.get(0)).get("a2"), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void aggMultiBuckets() throws Exception {
        String json = "{col1: {buckets: [{col2: {doc_count:1, buckets:[{key:'k3', max:{value:41}}]}, key:'k1'},{col2: {buckets:[{key:'k4', max:{value:42}}], doc_count:1}, key:'k2'}]}}";
        Json.Aggregations a = (Json.Aggregations)this.mapper.readValue(json, Json.Aggregations.class);
        Assertions.assertNotNull((Object)a);
        MatcherAssert.assertThat(a.asMap().keySet(), (Matcher)IsCollectionContaining.hasItem((Object)"col1"));
        MatcherAssert.assertThat((Object)a.get("col1"), (Matcher)CoreMatchers.instanceOf(Json.MultiBucketsAggregation.class));
        Json.MultiBucketsAggregation m = (Json.MultiBucketsAggregation)a.get("col1");
        MatcherAssert.assertThat((Object)m.getName(), (Matcher)CoreMatchers.is((Object)"col1"));
        MatcherAssert.assertThat((Object)m.buckets().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Json.Bucket)m.buckets().get(0)).key(), (Matcher)CoreMatchers.is((Object)"k1"));
        MatcherAssert.assertThat((Object)((Json.Bucket)m.buckets().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"col1"));
        MatcherAssert.assertThat(((Json.Bucket)m.buckets().get(0)).getAggregations().asMap().keySet(), (Matcher)IsCollectionContaining.hasItem((Object)"col2"));
        MatcherAssert.assertThat((Object)((Json.Bucket)m.buckets().get(1)).key(), (Matcher)CoreMatchers.is((Object)"k2"));
        ArrayList rows = new ArrayList();
        Json.visitValueNodes((Json.Aggregations)a, rows::add);
        MatcherAssert.assertThat((Object)rows.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(((Map)rows.get(0)).keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"col1", "col2", "max"}));
        MatcherAssert.assertThat(((Map)rows.get(0)).get("col1"), (Matcher)CoreMatchers.is((Object)"k1"));
        MatcherAssert.assertThat(((Map)rows.get(0)).get("col2"), (Matcher)CoreMatchers.is((Object)"k3"));
        MatcherAssert.assertThat(((Map)rows.get(0)).get("max"), (Matcher)CoreMatchers.is((Object)41));
        MatcherAssert.assertThat(((Map)rows.get(1)).keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"col1", "col2", "max"}));
        MatcherAssert.assertThat(((Map)rows.get(1)).get("col1"), (Matcher)CoreMatchers.is((Object)"k2"));
        MatcherAssert.assertThat(((Map)rows.get(1)).get("col2"), (Matcher)CoreMatchers.is((Object)"k4"));
        MatcherAssert.assertThat(((Map)rows.get(1)).get("max"), (Matcher)CoreMatchers.is((Object)42));
    }
}

