/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.elasticsearch.ElasticExtension;
import org.immutables.criteria.elasticsearch.ElasticModel;
import org.immutables.criteria.elasticsearch.ElasticModelCriteria;
import org.immutables.criteria.elasticsearch.ElasticModelRepository;
import org.immutables.criteria.elasticsearch.ElasticPersonTest;
import org.immutables.criteria.elasticsearch.ElasticsearchBackend;
import org.immutables.criteria.elasticsearch.ElasticsearchOps;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.ImmutableElasticsearchSetup;
import org.immutables.criteria.elasticsearch.IndexOps;
import org.immutables.criteria.expression.Ordering;
import org.immutables.criteria.personmodel.CriteriaChecker;
import org.immutables.criteria.repository.Fetcher;
import org.immutables.criteria.repository.Reader;
import org.immutables.criteria.repository.sync.SyncReader;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ElasticExtension.class})
class ScrollingTest {
    private static final ObjectMapper MAPPER = ElasticPersonTest.MAPPER;
    private final RestClient restClient;
    private static final int SIZE = 20;

    ScrollingTest(RestClient restClient) {
        this.restClient = restClient;
    }

    @BeforeEach
    void elasticseachInit() throws IOException {
        ImmutableMap model = ImmutableMap.builder().put((Object)"string", (Object)"keyword").put((Object)"optionalString", (Object)"keyword").put((Object)"bool", (Object)"boolean").put((Object)"intNumber", (Object)"integer").build();
        new IndexOps(this.restClient, MAPPER, "test").create((Map)model).blockingAwait();
        ElasticsearchBackend backend = this.backend();
        ElasticsearchOps ops = new ElasticsearchOps(this.restClient, "test", MAPPER, 1024);
        for (int i = 0; i < 20; ++i) {
            ObjectNode doc = MAPPER.createObjectNode().put("string", "s" + i).put("bool", true).put("intNumber", i);
            WriteResult writeResult = (WriteResult)ops.insertDocument(doc).blockingGet();
        }
    }

    private ElasticsearchBackend backend() {
        return this.backend(1024);
    }

    private ElasticsearchBackend backend(int scrollSize) {
        ImmutableElasticsearchSetup setup = ElasticsearchSetup.builder((RestClient)this.restClient).keyExtractorFactory(KeyExtractor.noKey()).objectMapper(MAPPER).indexResolver(ignore -> "test").scrollSize(scrollSize).build();
        return new ElasticsearchBackend((ElasticsearchSetup)setup);
    }

    @Test
    void noLimit() throws Exception {
        ElasticModelRepository repository = new ElasticModelRepository((Backend)this.backend(1024));
        CriteriaChecker.ofReader(repository.findAll()).toList(ElasticModel::string).hasSize(20);
        CriteriaChecker.ofReader((Reader)repository.findAll().orderBy(ElasticModelCriteria.elasticModel.string.asc(), new Ordering[0])).toList(ElasticModel::string).hasSize(20);
    }

    @Test
    void withLimit() throws Exception {
        int[] samples;
        for (int scrollSize : samples = new int[]{1, 2, 3, 19, 20, 21, 40, 400}) {
            for (int limit : samples) {
                ElasticModelRepository repository = new ElasticModelRepository((Backend)this.backend(scrollSize));
                int expected = Math.min(20, limit);
                CriteriaChecker.ofFetcher((Fetcher)repository.findAll().limit((long)limit)).toList(ElasticModel::string).hasSize(expected);
                List expectedStrings = IntStream.range(0, 20).mapToObj(i -> "s" + i).sorted().limit(expected).collect(Collectors.toList());
                CriteriaChecker.ofFetcher((Fetcher)((SyncReader)repository.findAll().orderBy(ElasticModelCriteria.elasticModel.string.asc(), new Ordering[0])).limit((long)limit)).toList(ElasticModel::string).isOf(expectedStrings);
            }
        }
    }

    private void assertNoActiveScrolls() throws Exception {
        Response response = this.restClient.performRequest(new Request("GET", "/_nodes/stats/indices/search"));
        try (InputStream is = response.getEntity().getContent();){
            ObjectNode node = (ObjectNode)this.backend().objectMapper.readValue(is, ObjectNode.class);
            String path = "/indices/search/scroll_current";
            JsonNode scrollCurrent = ((JsonNode)node.with("nodes").elements().next()).at("/indices/search/scroll_current");
            if (scrollCurrent.isMissingNode()) {
                throw new IllegalStateException("Couldn't find node at /indices/search/scroll_current");
            }
            int activeScrolls = scrollCurrent.asInt();
            if (activeScrolls != 0) {
                throw new AssertionError((Object)String.format("Expected no active scrolls but got %d. Current index stats %s", activeScrolls, node));
            }
        }
    }
}

