/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.function.Predicate;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.elasticsearch.ElasticsearchQueryVisitor;
import org.immutables.criteria.elasticsearch.QueryBuilders;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionConverter;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Visitors;

final class Elasticsearch {
    private Elasticsearch() {
    }

    static QueryBuilders.QueryBuilder toBuilder(Expression expression, PathNaming pathNaming, Predicate<Path> idPredicate) {
        return (QueryBuilders.QueryBuilder)expression.accept((ExpressionVisitor)new ElasticsearchQueryVisitor(pathNaming, idPredicate));
    }

    static ExpressionConverter<ObjectNode> constantScoreQuery(ObjectMapper mapper, PathNaming pathNaming, Predicate<Path> idPredicate) {
        Objects.requireNonNull(mapper, "expression");
        return expression -> {
            QueryBuilders.QueryBuilder builder = Elasticsearch.toBuilder(expression, pathNaming, idPredicate);
            return QueryBuilders.constantScoreQuery(builder).toJson(mapper);
        };
    }

    static Predicate<Path> idPredicate(KeyExtractor.KeyMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata");
        Predicate<Path> alwaysFalse = p -> false;
        if (!metadata.isKeyDefined() || !metadata.isExpression()) {
            return alwaysFalse;
        }
        if (metadata.keys().size() != 1) {
            return alwaysFalse;
        }
        Expression expression = (Expression)Iterables.getOnlyElement((Iterable)metadata.keys());
        return Visitors.maybePath((Expression)expression).map(p -> arg_0 -> ((Path)p).equals(arg_0)).orElse(alwaysFalse);
    }
}

