/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import org.immutables.check.Checkers;
import org.immutables.criteria.elasticsearch.Mapping;
import org.immutables.criteria.elasticsearch.Mappings;
import org.immutables.criteria.typemodel.TypeHolder;
import org.junit.jupiter.api.Test;

class MappingsTest {
    MappingsTest() {
    }

    @Test
    void basic() {
        Mapping mapping = Mappings.of(TypeHolder.StringHolder.class);
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("value")).name()).is("keyword");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("nullable")).name()).is("keyword");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("optional")).name()).is("keyword");
    }

    @Test
    void longHolder() {
        Mapping mapping = Mappings.of(TypeHolder.LongHolder.class);
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("value")).name()).is("long");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("boxed")).name()).is("long");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("optional")).name()).is("long");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("nullable")).name()).is("long");
    }

    @Test
    void doubleHolder() {
        Mapping mapping = Mappings.of(TypeHolder.DoubleHolder.class);
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("value")).name()).is("double");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("boxed")).name()).is("double");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("optional")).name()).is("double");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("nullable")).name()).is("double");
    }

    @Test
    void integerHolder() {
        Mapping mapping = Mappings.of(TypeHolder.IntegerHolder.class);
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("value")).name()).is("integer");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("boxed")).name()).is("integer");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("optional")).name()).is("integer");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("nullable")).name()).is("integer");
    }

    @Test
    void bigDecimalHolder() {
        Mapping mapping = Mappings.of(TypeHolder.BigDecimalHolder.class);
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("value")).name()).is("double");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("optional")).name()).is("double");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("nullable")).name()).is("double");
    }

    @Test
    void bigIntegerHolder() {
        Mapping mapping = Mappings.of(TypeHolder.BigIntegerHolder.class);
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("value")).name()).is("long");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("optional")).name()).is("long");
        Checkers.check((String)((Mapping.Datatype)mapping.fields().get("nullable")).name()).is("long");
    }
}

