/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.criteria.elasticsearch.Mapping;

class Mappings {
    Mappings() {
    }

    static Mapping of(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        Preconditions.checkArgument((boolean)clazz.isInterface(), (String)"Expected %s to be an interface", (Object[])new Object[]{clazz});
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Stream<Method> methods = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getParameterCount() == 0).filter(m -> m.getReturnType() != Void.class).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> m.getDeclaringClass() != Object.class);
        for (Method method : methods.collect(Collectors.toSet())) {
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray() || Iterable.class.isAssignableFrom(returnType)) continue;
            Type type = method.getGenericReturnType();
            map.put(method.getName(), Mappings.elasticType(type));
        }
        return Mapping.ofElastic(map);
    }

    private static String elasticType(Type type) {
        ParameterizedType parametrized;
        Objects.requireNonNull(type, "type");
        if (type instanceof ParameterizedType && (parametrized = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return Mappings.elasticType(parametrized.getActualTypeArguments()[0]);
        }
        if (type == String.class || type == Character.class || type == Character.TYPE) {
            return "keyword";
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "boolean";
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return "byte";
        }
        if (type == Short.class || type == Short.TYPE) {
            return "short";
        }
        if (type == Integer.class || type == Integer.TYPE || type == OptionalInt.class) {
            return "integer";
        }
        if (type == Long.class || type == Long.TYPE || type == OptionalLong.class) {
            return "long";
        }
        if (type == Double.class || type == Double.TYPE || type == OptionalDouble.class) {
            return "double";
        }
        if (type == Float.class || type == Float.TYPE) {
            return "float";
        }
        if (type == LocalDate.class || type == Instant.class || type == LocalDateTime.class || type == Date.class) {
            return "date";
        }
        if (type instanceof Class && ((Class)type).isEnum()) {
            return "keyword";
        }
        if (type == BigDecimal.class) {
            return "double";
        }
        if (type == BigInteger.class) {
            return "long";
        }
        throw new IllegalArgumentException("Don't know how to map " + type);
    }
}

