/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.function.Predicate;
import org.immutables.criteria.Criterias;
import org.immutables.criteria.Criterion;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.elasticsearch.Elasticsearch;
import org.immutables.criteria.elasticsearch.JsonChecker;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.personmodel.Person;
import org.immutables.criteria.personmodel.PersonCriteria;
import org.junit.jupiter.api.Test;

class ElasticsearchQueryVisitorTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Predicate<Path> idPredicate = Elasticsearch.idPredicate((KeyExtractor.KeyMetadata)KeyExtractor.defaultFactory().create(Person.class).metadata());
    private final PathNaming pathNaming = PathNaming.defaultNaming();
    private final PersonCriteria person = PersonCriteria.person;

    ElasticsearchQueryVisitorTest() {
    }

    @Test
    void ids() {
        this.filterToJson((PersonCriteria)this.person.id.is((Object)"id1")).is("{ids:{values:['id1']}}");
        this.filterToJson((PersonCriteria)this.person.id.in((Object)"id1", (Object)"id2", (Object[])new String[0])).is("{ids:{values:['id1', 'id2']}}");
        this.filterToJson((PersonCriteria)this.person.id.in(Collections.emptyList())).is("{ids:{values:[]}}");
        this.filterToJson((PersonCriteria)this.person.id.isNot((Object)"id1")).is("{bool: {must_not: {ids:{values:['id1']}}}}");
    }

    private JsonChecker filterToJson(PersonCriteria criteria) {
        Expression expr = (Expression)Criterias.toQuery((Criterion)criteria).filter().get();
        ObjectNode node = Elasticsearch.toBuilder((Expression)expr, (PathNaming)this.pathNaming, this.idPredicate).toJson(this.objectMapper);
        return JsonChecker.of((JsonNode)node);
    }
}

