/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.elasticsearch.ElasticExtension;
import org.immutables.criteria.elasticsearch.ElasticPersonTest;
import org.immutables.criteria.elasticsearch.ElasticsearchBackend;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.IndexOps;
import org.immutables.criteria.elasticsearch.PersonModel;
import org.immutables.criteria.personmodel.PersonAggregationTest;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ElasticExtension.class})
public class ElasticAggregationTest
extends PersonAggregationTest {
    private static final ObjectMapper MAPPER = ElasticPersonTest.MAPPER;
    private static final String INDEX_NAME = ElasticPersonTest.INDEX_NAME;
    private final ElasticsearchBackend backend;

    ElasticAggregationTest(RestClient restClient) throws IOException {
        IndexOps ops = new IndexOps(restClient, MAPPER, INDEX_NAME);
        ops.create(PersonModel.MAPPING).blockingAwait();
        this.backend = new ElasticsearchBackend((ElasticsearchSetup)ElasticsearchSetup.builder((RestClient)restClient).objectMapper(MAPPER).build());
    }

    protected Backend backend() {
        return this.backend;
    }
}

