/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.elasticsearch.IndexOps;
import org.immutables.criteria.elasticsearch.Json;
import org.immutables.criteria.elasticsearch.JsonConverter;
import org.immutables.criteria.elasticsearch.Mapping;
import org.immutables.criteria.elasticsearch.RxJavaTransport;
import org.immutables.criteria.elasticsearch.Scrolling;
import org.immutables.criteria.elasticsearch.Version;

class ElasticsearchOps {
    private static final Logger logger = Logger.getLogger(ElasticsearchOps.class.getName());
    private final RxJavaTransport transport;
    private final ObjectMapper mapper;
    private final String index;
    final Mapping mapping;
    final Version version;
    final int scrollSize;

    ElasticsearchOps(RestClient restClient, String index, ObjectMapper mapper, int scrollSize) {
        this.transport = new RxJavaTransport(restClient);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.index = Objects.requireNonNull(index, "index");
        Preconditions.checkArgument((scrollSize > 0 ? 1 : 0) != 0, (String)"Invalid scrollSize: %s", (Object[])new Object[]{scrollSize});
        this.scrollSize = scrollSize;
        IndexOps ops = new IndexOps(restClient, mapper, index);
        this.mapping = (Mapping)ops.mapping().blockingGet();
        this.version = (Version)ops.version().blockingGet();
    }

    Single<WriteResult> insertDocument(ObjectNode document) throws IOException {
        Objects.requireNonNull(document, "document");
        String uri = String.format(Locale.ROOT, "/%s/_doc?refresh", this.index);
        StringEntity entity = new StringEntity(this.mapper().writeValueAsString((Object)document), ContentType.APPLICATION_JSON);
        Request r = new Request("POST", uri);
        r.setEntity((HttpEntity)entity);
        return this.transport.execute(r).map(x -> WriteResult.unknown());
    }

    Single<WriteResult> insertBulk(List<ObjectNode> documents) {
        return Single.defer(() -> this.insertBulkInternal(documents));
    }

    Single<WriteResult> deleteByQuery(ObjectNode query) {
        Objects.requireNonNull(query, "query");
        Request request = new Request("POST", String.format("/%s/_delete_by_query", this.index));
        request.addParameter("refresh", "true");
        request.setJsonEntity(query.toString());
        return this.transport.execute(request).map(x -> WriteResult.unknown());
    }

    private Single<WriteResult> insertBulkInternal(List<ObjectNode> documents) throws JsonProcessingException {
        Objects.requireNonNull(documents, "documents");
        if (documents.isEmpty()) {
            return Single.just((Object)WriteResult.empty());
        }
        ArrayList<String> bulk = new ArrayList<String>(documents.size() * 2);
        for (ObjectNode doc : documents) {
            ObjectNode header = this.mapper.createObjectNode();
            header.with("index").put("_index", this.index);
            if (doc.has("_id")) {
                header.with("index").set("_id", doc.get("_id"));
                doc.remove("_id");
            }
            bulk.add(header.toString());
            bulk.add(this.mapper().writeValueAsString((Object)doc));
        }
        StringEntity entity = new StringEntity(String.join((CharSequence)"\n", bulk) + "\n", ContentType.APPLICATION_JSON);
        Request r = new Request("POST", "/_bulk?refresh");
        r.setEntity((HttpEntity)entity);
        return this.transport.execute(r).map(x -> WriteResult.unknown());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T convert(Response response, Class<T> type) {
        try (InputStream is = response.getEntity().getContent();){
            Object object = this.mapper.readValue(is, type);
            return (T)object;
        }
        catch (IOException e) {
            String message = String.format("Couldn't parse HTTP response %s into %s", response, type.getSimpleName());
            throw new UncheckedIOException(message, e);
        }
    }

    private Function<Response, Json.Result> responseConverter() {
        return response -> this.convert((Response)response, (Class)Json.Result.class);
    }

    <T> Flowable<T> scrolledSearch(ObjectNode query, JsonConverter<T> converter) {
        return new Scrolling<T>(this, converter).scroll(query);
    }

    Single<Json.Result> nextScroll(String scrollId) {
        Request request = new Request("POST", "/_search/scroll");
        ObjectNode payload = this.mapper.createObjectNode().put("scroll", "1m").put("scroll_id", scrollId);
        request.setJsonEntity(payload.toString());
        return this.transport.execute(request).map(r -> this.responseConverter().apply((Response)r));
    }

    Completable closeScroll(Iterable<String> scrollIds) {
        ObjectNode payload = this.mapper.createObjectNode();
        ArrayNode array = payload.withArray("scroll_id");
        scrollIds.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        Request request = new Request("DELETE", "/_search/scroll");
        request.setJsonEntity(payload.toString());
        return this.transport.execute(request).ignoreElement();
    }

    <T> Flowable<T> search(ObjectNode query, JsonConverter<T> converter) {
        return this.searchRaw(query, Collections.emptyMap()).toFlowable().flatMapIterable(r -> r.searchHits().hits()).map(x -> converter.convert((JsonNode)x.source()));
    }

    Single<Json.Count> count(ObjectNode query) {
        Request request = new Request("POST", String.format("/%s/_count", this.index));
        request.setJsonEntity(query.toString());
        return this.transport.execute(request).map(r -> this.convert((Response)r, (Class)Json.Count.class));
    }

    Single<Json.Result> searchRaw(ObjectNode query, Map<String, String> httpParams) {
        Request request = new Request("POST", String.format("/%s/_search", this.index));
        httpParams.forEach((arg_0, arg_1) -> ((Request)request).addParameter(arg_0, arg_1));
        request.setJsonEntity(query.toString());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Performing search {0} on {1}", new Object[]{query, request});
        }
        return this.transport.execute(request).map(r -> this.responseConverter().apply((Response)r));
    }

    ObjectMapper mapper() {
        return this.mapper;
    }
}

