/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.elasticsearch.ImmutableElasticsearchSetup;
import org.immutables.criteria.elasticsearch.IndexResolver;
import org.immutables.value.Value;

@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
@Value.Immutable
public interface ElasticsearchSetup {
    @Value.Parameter
    public RestClient restClient();

    @Value.Default
    default public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Value.Default
    default public IndexResolver resolver() {
        return IndexResolver.defaultResolver();
    }

    @Value.Default
    default public int scrollSize() {
        return 1024;
    }

    public static ElasticsearchSetup of(RestClient restClient) {
        return ElasticsearchSetup.builder(restClient).build();
    }

    public static Builder builder(RestClient restClient) {
        return new Builder().restClient(restClient);
    }

    public static class Builder
    extends ImmutableElasticsearchSetup.Builder {
    }
}

