/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.DefaultResult;
import org.immutables.criteria.backend.IdExtractor;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.elasticsearch.AggregateQueryBuilder;
import org.immutables.criteria.elasticsearch.DefaultConverter;
import org.immutables.criteria.elasticsearch.Elasticsearch;
import org.immutables.criteria.elasticsearch.ElasticsearchOps;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.IndexResolver;
import org.immutables.criteria.elasticsearch.JsonConverter;
import org.immutables.criteria.elasticsearch.ToTupleConverter;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;
import org.reactivestreams.Publisher;

public class ElasticsearchBackend
implements Backend {
    final RestClient restClient;
    final ObjectMapper objectMapper;
    private final IndexResolver resolver;
    private final int scrollSize;

    public ElasticsearchBackend(ElasticsearchSetup setup) {
        Objects.requireNonNull(setup, "setup");
        this.restClient = setup.restClient();
        this.objectMapper = setup.objectMapper();
        this.resolver = setup.resolver();
        this.scrollSize = setup.scrollSize();
    }

    public Backend.Session open(Class<?> entityType) {
        Object index = this.resolver.resolve((Class)entityType);
        return new Session(entityType, new ElasticsearchOps(this.restClient, (String)index, this.objectMapper, this.scrollSize));
    }

    private static class Session
    implements Backend.Session {
        private final Class<?> entityType;
        private final ObjectMapper objectMapper;
        private final ElasticsearchOps ops;
        private final IdExtractor<Object, Object> idExtractor;
        private final JsonConverter<Object> converter;
        private final boolean hasId;

        private Session(Class<?> entityClass, ElasticsearchOps ops) {
            Objects.requireNonNull(entityClass, "entityClass");
            this.entityType = entityClass;
            this.ops = Objects.requireNonNull(ops, "ops");
            this.objectMapper = ops.mapper();
            IdExtractor idExtractor = IdExtractor.from(x -> x);
            boolean hasId = false;
            try {
                idExtractor = IdExtractor.reflection(entityClass);
                hasId = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.idExtractor = idExtractor;
            this.converter = DefaultConverter.of(this.objectMapper, entityClass);
            this.hasId = hasId;
        }

        public Class<?> entityType() {
            return this.entityType;
        }

        public Backend.Result execute(Backend.Operation query) {
            Objects.requireNonNull(query, "query");
            if (query instanceof StandardOperations.Insert) {
                return DefaultResult.of(this.insert((StandardOperations.Insert)query));
            }
            if (query instanceof StandardOperations.Select) {
                return DefaultResult.of(this.select((StandardOperations.Select)query));
            }
            return DefaultResult.of((Publisher)Flowable.error((Throwable)new UnsupportedOperationException(String.format("Op %s not supported", query))));
        }

        private Flowable<ProjectedTuple> aggregate(StandardOperations.Select op) {
            Query query = op.query();
            Preconditions.checkArgument((boolean)query.hasAggregations(), (Object)"No Aggregations");
            AggregateQueryBuilder builder = new AggregateQueryBuilder(query, this.objectMapper, this.ops.mapping);
            return this.ops.searchRaw(builder.jsonQuery(), Collections.emptyMap()).map(builder::processResult).toFlowable().flatMapIterable(x -> x);
        }

        private Flowable<?> select(StandardOperations.Select op) {
            Query query = op.query();
            if (query.hasAggregations()) {
                return this.aggregate(op);
            }
            ObjectNode json = this.objectMapper.createObjectNode();
            query.filter().ifPresent(f -> json.set("query", (JsonNode)Elasticsearch.query(this.objectMapper).convert(f)));
            query.limit().ifPresent(limit -> json.put("size", limit));
            query.offset().ifPresent(offset -> json.put("from", offset));
            if (!query.collations().isEmpty()) {
                ArrayNode sort = json.withArray("sort");
                query.collations().forEach(c -> sort.add((JsonNode)this.objectMapper.createObjectNode().put(c.path().toStringPath(), c.direction().isAscending() ? "asc" : "desc")));
            }
            ToTupleConverter converter = this.converter;
            if (query.hasProjections()) {
                ArrayNode projection = query.projections().stream().map(p -> ((Path)p).toStringPath()).reduce(this.objectMapper.createArrayNode(), ArrayNode::add, (old, newNode) -> newNode);
                json.set("_source", (JsonNode)projection);
                converter = new ToTupleConverter(query, this.objectMapper);
            }
            Flowable<Object> flowable = query.offset().isPresent() ? this.ops.search(json, converter) : this.ops.scrolledSearch(json, converter);
            return flowable;
        }

        private Publisher<WriteResult> insert(StandardOperations.Insert insert) {
            if (insert.values().isEmpty()) {
                return Flowable.just((Object)WriteResult.empty());
            }
            BiFunction<Object, ObjectNode, ObjectNode> idFn = (entity, node) -> this.hasId ? (ObjectNode)node.set("_id", this.objectMapper.valueToTree(this.idExtractor.extract(entity))) : node;
            List<ObjectNode> docs = insert.values().stream().map(e -> (ObjectNode)idFn.apply(e, (ObjectNode)this.objectMapper.valueToTree(e))).collect(Collectors.toList());
            return this.ops.insertBulk(docs).toFlowable();
        }
    }
}

