/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.backend.UniqueCachedNaming;
import org.immutables.criteria.elasticsearch.Elasticsearch;
import org.immutables.criteria.elasticsearch.Json;
import org.immutables.criteria.elasticsearch.Mapping;
import org.immutables.criteria.expression.AggregationCall;
import org.immutables.criteria.expression.AggregationOperators;
import org.immutables.criteria.expression.Collation;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;

class AggregateQueryBuilder {
    private static final String AGGREGATIONS = "aggregations";
    private final Query query;
    private final Mapping mapping;
    private final UniqueCachedNaming<Expression> naming;
    private final ObjectMapper mapper;
    private final JsonNodeFactory nodeFactory;

    AggregateQueryBuilder(Query query, ObjectMapper mapper, Mapping mapping) {
        this.query = Objects.requireNonNull(query, "query");
        Preconditions.checkArgument((boolean)query.hasAggregations(), (String)"no aggregations for query %s", (Object[])new Object[]{query});
        this.mapping = mapping;
        ArrayList toName = new ArrayList();
        toName.addAll(query.projections());
        toName.addAll(query.collations().stream().map(Collation::expression).collect(Collectors.toList()));
        toName.addAll(query.groupBy());
        this.naming = UniqueCachedNaming.of(toName);
        this.mapper = mapper;
        this.nodeFactory = mapper.getNodeFactory();
    }

    ObjectNode jsonQuery() {
        if (!this.query.groupBy().isEmpty() && this.query.offset().isPresent()) {
            String message = "Currently ES doesn't support generic pagination with aggregations. You can still use LIMIT keyword (without OFFSET). For more details see https://github.com/elastic/elasticsearch/issues/4915";
            throw new UnsupportedOperationException(message);
        }
        ObjectNode json = this.nodeFactory.objectNode();
        json.put("_source", false);
        json.put("size", 0);
        this.query.filter().ifPresent(f -> json.set("query", (JsonNode)Elasticsearch.query(this.mapper).convert(f)));
        LinkedHashSet orderedGroupBy = new LinkedHashSet();
        orderedGroupBy.addAll(this.query.collations().stream().map(Collation::expression).collect(Collectors.toList()));
        orderedGroupBy.addAll(this.query.groupBy());
        ObjectNode parent = json.with(AGGREGATIONS);
        for (Expression expr : orderedGroupBy) {
            String name = ((Path)expr).toStringPath();
            String aggName = this.naming.name((Object)expr);
            ObjectNode section = parent.with(aggName);
            ObjectNode terms = section.with("terms");
            terms.put("field", name);
            this.mapping.missingValueFor(name).ifPresent(m -> terms.set("missing", m));
            this.query.limit().ifPresent(limit -> terms.put("size", limit));
            this.query.collations().stream().filter(c -> c.path().toStringPath().equals(name)).findAny().ifPresent(col -> terms.with("order").put("_key", col.direction().isAscending() ? "asc" : "desc"));
            parent = section.with(AGGREGATIONS);
        }
        for (Expression expr : this.query.projections()) {
            if (!(expr instanceof AggregationCall)) continue;
            AggregationCall call = (AggregationCall)expr;
            ObjectNode agg = this.nodeFactory.objectNode();
            String field = ((Path)call.arguments().get(0)).toStringPath();
            agg.with(AggregateQueryBuilder.toElasticAggregate(call)).put("field", field);
            parent.set(this.naming.name((Object)call), (JsonNode)agg);
        }
        AggregateQueryBuilder.removeEmptyAggregation((JsonNode)json);
        return json;
    }

    List<ProjectedTuple> processResult(Json.Result result) {
        ArrayList<ProjectedTuple> tuples = new ArrayList<ProjectedTuple>();
        if (result.aggregations() != null) {
            Converter converter = this.naming.asConverter().reverse();
            Json.visitValueNodes(result.aggregations(), m -> {
                HashMap values = Maps.newHashMapWithExpectedSize((int)this.query.projections().size());
                for (String field : m.keySet()) {
                    Expression expression = (Expression)converter.convert((Object)field);
                    Object value = m.get(field);
                    if (value == null) {
                        value = NullNode.getInstance();
                    } else if (value instanceof Number && (expression.returnType() == LocalDate.class || expression.returnType() == LocalDateTime.class)) {
                        Instant instant = Instant.ofEpochMilli(((Number)value).longValue());
                        value = this.nodeFactory.textNode(instant.toString());
                    }
                    values.put(expression, this.mapper.convertValue(value, this.mapper.getTypeFactory().constructType(expression.returnType())));
                }
                List projections = this.query.projections().stream().map(values::get).collect(Collectors.toList());
                tuples.add(ProjectedTuple.of((Iterable)this.query.projections(), projections));
            });
        }
        long total = result.searchHits().total().value();
        return tuples;
    }

    private static void removeEmptyAggregation(JsonNode node) {
        if (!node.has(AGGREGATIONS)) {
            node.elements().forEachRemaining(AggregateQueryBuilder::removeEmptyAggregation);
            return;
        }
        JsonNode agg = node.get(AGGREGATIONS);
        if (agg.size() == 0) {
            ((ObjectNode)node).remove(AGGREGATIONS);
        } else {
            AggregateQueryBuilder.removeEmptyAggregation(agg);
        }
    }

    private static String toElasticAggregate(AggregationCall call) {
        AggregationOperators kind = (AggregationOperators)call.operator();
        switch (kind) {
            case COUNT: {
                return "value_count";
            }
            case SUM: {
                return "sum";
            }
            case MIN: {
                return "min";
            }
            case MAX: {
                return "max";
            }
            case AVG: {
                return "avg";
            }
        }
        throw new IllegalArgumentException("Unknown aggregation kind " + kind + " for " + call);
    }
}

