/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.immutables.criteria.elasticsearch.QueryBuilders;
import org.junit.Assert;
import org.junit.Test;

public class QueryBuildersTest {
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void term() throws Exception {
        Assert.assertEquals((Object)"{\"term\":{\"foo\":\"bar\"}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (String)"bar")));
        Assert.assertEquals((Object)"{\"term\":{\"bar\":\"foo\"}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"bar", (String)"foo")));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":\"A\"}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (char)'A')));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":true}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (boolean)true)));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":false}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (boolean)false)));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":0}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (int)0)));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":123}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (long)123L)));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":41}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (int)41)));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":42.42}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (double)42.42)));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":1.1}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (float)1.1f)));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":1}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (Object)new BigDecimal(1))));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":121}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (Object)new BigInteger("121"))));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":111}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (Object)new AtomicLong(111L))));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":222}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (Object)new AtomicInteger(222))));
        Assert.assertEquals((Object)"{\"term\":{\"foo\":true}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (Object)new AtomicBoolean(true))));
    }

    @Test
    public void terms() throws Exception {
        Assert.assertEquals((Object)"{\"terms\":{\"foo\":[]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"foo", Collections.emptyList())));
        Assert.assertEquals((Object)"{\"terms\":{\"bar\":[]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"bar", Collections.emptySet())));
        Assert.assertEquals((Object)"{\"terms\":{\"singleton\":[0]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"singleton", Collections.singleton(0))));
        Assert.assertEquals((Object)"{\"terms\":{\"foo\":[true]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"foo", Collections.singleton(true))));
        Assert.assertEquals((Object)"{\"terms\":{\"foo\":[\"bar\"]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"foo", Collections.singleton("bar"))));
        Assert.assertEquals((Object)"{\"terms\":{\"foo\":[\"bar\"]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"foo", Collections.singletonList("bar"))));
        Assert.assertEquals((Object)"{\"terms\":{\"foo\":[true,false]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"foo", Arrays.asList(true, false))));
        Assert.assertEquals((Object)"{\"terms\":{\"foo\":[1,2,3]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"foo", Arrays.asList(1, 2, 3))));
        Assert.assertEquals((Object)"{\"terms\":{\"foo\":[1.1,2.2,3.3]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.termsQuery((String)"foo", Arrays.asList(1.1, 2.2, 3.3))));
    }

    @Test
    public void boolQuery() throws Exception {
        QueryBuilders.BoolQueryBuilder q1 = QueryBuilders.boolQuery().must((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"foo", (String)"bar"));
        Assert.assertEquals((Object)"{\"bool\":{\"must\":{\"term\":{\"foo\":\"bar\"}}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)q1));
        QueryBuilders.BoolQueryBuilder q2 = QueryBuilders.boolQuery().must((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"f1", (String)"v1")).must((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"f2", (String)"v2"));
        Assert.assertEquals((Object)"{\"bool\":{\"must\":[{\"term\":{\"f1\":\"v1\"}},{\"term\":{\"f2\":\"v2\"}}]}}", (Object)this.toJson((QueryBuilders.QueryBuilder)q2));
        QueryBuilders.BoolQueryBuilder q3 = QueryBuilders.boolQuery().mustNot((QueryBuilders.QueryBuilder)QueryBuilders.termQuery((String)"f1", (String)"v1"));
        Assert.assertEquals((Object)"{\"bool\":{\"must_not\":{\"term\":{\"f1\":\"v1\"}}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)q3));
    }

    @Test
    public void exists() throws Exception {
        Assert.assertEquals((Object)"{\"exists\":{\"field\":\"foo\"}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.existsQuery((String)"foo")));
    }

    @Test
    public void range() throws Exception {
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"lt\":0}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").lt((Object)0)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gt\":0}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gt((Object)0)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gte\":0}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gte((Object)0)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"lte\":0}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").lte((Object)0)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gt\":1,\"lt\":2}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gt((Object)1).lt((Object)2)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gt\":11,\"lt\":0}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").lt((Object)0).gt((Object)11)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gt\":1,\"lte\":2}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gt((Object)1).lte((Object)2)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gte\":1,\"lte\":\"zz\"}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gte((Object)1).lte((Object)"zz")));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gte\":1}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gte((Object)1)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gte\":\"zz\"}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gte((Object)"zz")));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gt\":\"a\",\"lt\":\"z\"}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gt((Object)"a").lt((Object)"z")));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"gte\":3}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").gt((Object)1).gt((Object)2).gte((Object)3)));
        Assert.assertEquals((Object)"{\"range\":{\"f\":{\"lte\":3}}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.rangeQuery((String)"f").lt((Object)1).lt((Object)2).lte((Object)3)));
    }

    @Test
    public void matchAll() {
        Assert.assertEquals((Object)"{\"match_all\":{}}", (Object)this.toJson((QueryBuilders.QueryBuilder)QueryBuilders.matchAll()));
    }

    private String toJson(QueryBuilders.QueryBuilder builder) {
        return builder.toJson(this.mapper).toString();
    }
}

