/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import org.junit.Assert;

class JsonChecker {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES}).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.QUOTE_FIELD_NAMES});
    private final JsonNode actual;

    private JsonChecker(JsonNode actual) {
        this.actual = Objects.requireNonNull(actual, "actual");
    }

    static JsonChecker of(JsonNode actual) {
        return new JsonChecker(actual);
    }

    private void assertSameJson(JsonNode expected) throws JsonProcessingException {
        Objects.requireNonNull(expected, "expected");
        if (!this.actual.equals((Object)expected)) {
            ObjectWriter writer = MAPPER.writerWithDefaultPrettyPrinter();
            String expectedPretty = writer.writeValueAsString((Object)expected);
            String actualPretty = writer.writeValueAsString((Object)this.actual);
            Assert.assertEquals((Object)expectedPretty, (Object)actualPretty);
        }
    }

    void is(String ... lines) {
        this.is(Arrays.asList(lines));
    }

    void is(Iterable<String> lines) {
        try {
            JsonNode expected = JsonChecker.expandDots(MAPPER.readTree(String.join((CharSequence)"", lines)));
            this.is(expected);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void is(JsonNode expected) {
        try {
            this.assertSameJson(expected);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private static <T extends JsonNode> T expandDots(T parent) {
        Objects.requireNonNull(parent, "parent");
        if (parent.isValueNode()) {
            return (T)parent.deepCopy();
        }
        if (parent.isArray()) {
            ArrayNode arr = (ArrayNode)parent;
            ArrayNode copy = arr.arrayNode();
            arr.elements().forEachRemaining(e -> copy.add(JsonChecker.expandDots(e)));
            return (T)copy;
        }
        ObjectNode objectNode = (ObjectNode)parent;
        ObjectNode copy = objectNode.objectNode();
        objectNode.fields().forEachRemaining(e -> {
            String property = (String)e.getKey();
            JsonNode node = (JsonNode)e.getValue();
            String[] names = property.split("\\.");
            ObjectNode copy2 = copy;
            for (int i = 0; i < names.length - 1; ++i) {
                copy2 = copy2.with(names[i]);
            }
            copy2.set(names[names.length - 1], JsonChecker.expandDots(node));
        });
        return (T)copy;
    }
}

