/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.criteria.elasticsearch.ElasticModel;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ElasticModel", generator="Immutables")
@Immutable
public final class ImmutableElasticModel
implements ElasticModel {
    private final String string;
    @Nullable
    private final String optionalString;
    private final boolean bool;
    private final int intNumber;

    private ImmutableElasticModel(String string, @Nullable String optionalString, boolean bool, int intNumber) {
        this.string = string;
        this.optionalString = optionalString;
        this.bool = bool;
        this.intNumber = intNumber;
    }

    @Override
    @JsonProperty(value="string")
    public String string() {
        return this.string;
    }

    @Override
    @JsonProperty(value="optionalString")
    public Optional<String> optionalString() {
        return Optional.ofNullable(this.optionalString);
    }

    @Override
    @JsonProperty(value="bool")
    public boolean bool() {
        return this.bool;
    }

    @Override
    @JsonProperty(value="intNumber")
    public int intNumber() {
        return this.intNumber;
    }

    public final ImmutableElasticModel withString(String value) {
        String newValue = Objects.requireNonNull(value, "string");
        if (this.string.equals(newValue)) {
            return this;
        }
        return new ImmutableElasticModel(newValue, this.optionalString, this.bool, this.intNumber);
    }

    public final ImmutableElasticModel withOptionalString(String value) {
        String newValue = Objects.requireNonNull(value, "optionalString");
        if (Objects.equals(this.optionalString, newValue)) {
            return this;
        }
        return new ImmutableElasticModel(this.string, newValue, this.bool, this.intNumber);
    }

    public final ImmutableElasticModel withOptionalString(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.optionalString, value)) {
            return this;
        }
        return new ImmutableElasticModel(this.string, value, this.bool, this.intNumber);
    }

    public final ImmutableElasticModel withBool(boolean value) {
        if (this.bool == value) {
            return this;
        }
        return new ImmutableElasticModel(this.string, this.optionalString, value, this.intNumber);
    }

    public final ImmutableElasticModel withIntNumber(int value) {
        if (this.intNumber == value) {
            return this;
        }
        return new ImmutableElasticModel(this.string, this.optionalString, this.bool, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableElasticModel && this.equalTo((ImmutableElasticModel)another);
    }

    private boolean equalTo(ImmutableElasticModel another) {
        return this.string.equals(another.string) && Objects.equals(this.optionalString, another.optionalString) && this.bool == another.bool && this.intNumber == another.intNumber;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.string.hashCode();
        h += (h << 5) + Objects.hashCode(this.optionalString);
        h += (h << 5) + Booleans.hashCode((boolean)this.bool);
        h += (h << 5) + this.intNumber;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ElasticModel").omitNullValues().add("string", (Object)this.string).add("optionalString", (Object)this.optionalString).add("bool", this.bool).add("intNumber", this.intNumber).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableElasticModel fromJson(Json json) {
        Builder builder = ImmutableElasticModel.builder();
        if (json.string != null) {
            builder.string(json.string);
        }
        if (json.optionalString != null) {
            builder.optionalString(json.optionalString);
        }
        if (json.boolIsSet) {
            builder.bool(json.bool);
        }
        if (json.intNumberIsSet) {
            builder.intNumber(json.intNumber);
        }
        return builder.build();
    }

    public static ImmutableElasticModel copyOf(ElasticModel instance) {
        if (instance instanceof ImmutableElasticModel) {
            return (ImmutableElasticModel)instance;
        }
        return ImmutableElasticModel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ElasticModel", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STRING = 1L;
        private static final long INIT_BIT_BOOL = 2L;
        private static final long INIT_BIT_INT_NUMBER = 4L;
        private long initBits = 7L;
        @Nullable
        private String string;
        @Nullable
        private String optionalString;
        private boolean bool;
        private int intNumber;

        private Builder() {
        }

        public final Builder from(ElasticModel instance) {
            Objects.requireNonNull(instance, "instance");
            this.string(instance.string());
            Optional<String> optionalStringOptional = instance.optionalString();
            if (optionalStringOptional.isPresent()) {
                this.optionalString(optionalStringOptional);
            }
            this.bool(instance.bool());
            this.intNumber(instance.intNumber());
            return this;
        }

        @JsonProperty(value="string")
        public final Builder string(String string) {
            this.string = Objects.requireNonNull(string, "string");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder optionalString(String optionalString) {
            this.optionalString = Objects.requireNonNull(optionalString, "optionalString");
            return this;
        }

        @JsonProperty(value="optionalString")
        public final Builder optionalString(Optional<String> optionalString) {
            this.optionalString = optionalString.orElse(null);
            return this;
        }

        @JsonProperty(value="bool")
        public final Builder bool(boolean bool) {
            this.bool = bool;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="intNumber")
        public final Builder intNumber(int intNumber) {
            this.intNumber = intNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableElasticModel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableElasticModel(this.string, this.optionalString, this.bool, this.intNumber);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("string");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bool");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("intNumber");
            }
            return "Cannot build ElasticModel, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ElasticModel", generator="Immutables")
    static final class Json
    implements ElasticModel {
        @Nullable
        String string;
        @Nullable
        Optional<String> optionalString = Optional.empty();
        boolean bool;
        boolean boolIsSet;
        int intNumber;
        boolean intNumberIsSet;

        Json() {
        }

        @JsonProperty(value="string")
        public void setString(String string) {
            this.string = string;
        }

        @JsonProperty(value="optionalString")
        public void setOptionalString(Optional<String> optionalString) {
            this.optionalString = optionalString;
        }

        @JsonProperty(value="bool")
        public void setBool(boolean bool) {
            this.bool = bool;
            this.boolIsSet = true;
        }

        @JsonProperty(value="intNumber")
        public void setIntNumber(int intNumber) {
            this.intNumber = intNumber;
            this.intNumberIsSet = true;
        }

        @Override
        public String string() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> optionalString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean bool() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int intNumber() {
            throw new UnsupportedOperationException();
        }
    }
}

