/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.transport.TransportAddress;
import org.immutables.criteria.elasticsearch.EmbeddedElasticsearchNode;
import org.junit.rules.ExternalResource;

class EmbeddedElasticsearchResource
extends ExternalResource
implements Closeable {
    private final EmbeddedElasticsearchNode node;
    private final Closer closer;
    private RestClient client;

    private EmbeddedElasticsearchResource(EmbeddedElasticsearchNode node) {
        this.node = Objects.requireNonNull(node, "node");
        this.closer = Closer.create();
        this.closer.register((Closeable)this.node);
    }

    protected void before() throws Throwable {
        this.node.start();
    }

    protected void after() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public static EmbeddedElasticsearchResource create() {
        return new EmbeddedElasticsearchResource(EmbeddedElasticsearchNode.create());
    }

    RestClient restClient() {
        if (this.client != null) {
            return this.client;
        }
        RestClient client = RestClient.builder((HttpHost[])new HttpHost[]{this.httpHost()}).build();
        this.closer.register((Closeable)client);
        this.client = client;
        return client;
    }

    private HttpHost httpHost() {
        TransportAddress address = this.node.httpAddress();
        return new HttpHost(address.getAddress(), address.getPort());
    }
}

