/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.Criterion;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.ContainerNaming;
import org.immutables.criteria.elasticsearch.ElasticsearchBackend;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.EmbeddedElasticsearchResource;
import org.immutables.criteria.elasticsearch.IndexOps;
import org.immutables.criteria.elasticsearch.PersonModel;
import org.immutables.criteria.matcher.StringMatcher;
import org.immutables.criteria.personmodel.AbstractPersonTest;
import org.immutables.criteria.personmodel.Person;
import org.immutables.criteria.personmodel.PersonGenerator;
import org.immutables.criteria.repository.Reader;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ElasticPersonTest
extends AbstractPersonTest {
    @ClassRule
    public static final EmbeddedElasticsearchResource ELASTIC = EmbeddedElasticsearchResource.create();
    static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new GuavaModule()).registerModule((Module)new Jdk8Module());
    static final String INDEX_NAME = ContainerNaming.DEFAULT.name(Person.class);
    private ElasticsearchBackend backend;
    private IndexOps ops;

    @Before
    public void setupRepository() throws Exception {
        this.ops = new IndexOps(ELASTIC.restClient(), MAPPER, INDEX_NAME);
        this.ops.create(PersonModel.MAPPING).blockingGet();
        this.backend = new ElasticsearchBackend((ElasticsearchSetup)ElasticsearchSetup.builder((RestClient)ELASTIC.restClient()).objectMapper(MAPPER).build());
    }

    @After
    public void tearDown() throws Exception {
        if (this.ops != null) {
            this.ops.delete().blockingGet();
        }
    }

    @Test
    public void regex_forElastic() {
        PersonGenerator generator = new PersonGenerator();
        this.insert(new Person[]{generator.next().withFullName("John")});
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile("John")))).hasSize(1);
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile("J.*n")))).hasSize(1);
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.not(s -> (StringMatcher.Self)s.matches(Pattern.compile("J.*n"))))).empty();
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile("J..n")))).hasSize(1);
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile("J...")))).hasSize(1);
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile("...n")))).hasSize(1);
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile(".*")))).hasSize(1);
        this.insert(new Person[]{generator.next().withFullName("Mary")});
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile("J.*n")))).hasSize(1);
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile("M.*ry")))).hasSize(1);
        this.check((Reader)this.repository().find((Criterion)this.person.fullName.matches(Pattern.compile(".*")))).hasSize(2);
    }

    protected Set<AbstractPersonTest.Feature> features() {
        return EnumSet.of(AbstractPersonTest.Feature.DELETE, new AbstractPersonTest.Feature[]{AbstractPersonTest.Feature.QUERY, AbstractPersonTest.Feature.QUERY_WITH_LIMIT, AbstractPersonTest.Feature.QUERY_WITH_PROJECTION, AbstractPersonTest.Feature.QUERY_WITH_OFFSET, AbstractPersonTest.Feature.ORDER_BY, AbstractPersonTest.Feature.STRING_PREFIX_SUFFIX});
    }

    protected Backend backend() {
        return this.backend;
    }
}

