/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.elasticsearch.ElasticPersonTest;
import org.immutables.criteria.elasticsearch.ElasticsearchBackend;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.EmbeddedElasticsearchResource;
import org.immutables.criteria.elasticsearch.IndexOps;
import org.immutables.criteria.elasticsearch.PersonModel;
import org.immutables.criteria.personmodel.PersonAggregationTest;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;

public class ElasticAggregationTest
extends PersonAggregationTest {
    @ClassRule
    public static final EmbeddedElasticsearchResource ELASTIC = EmbeddedElasticsearchResource.create();
    static final ObjectMapper MAPPER = ElasticPersonTest.MAPPER;
    static final String INDEX_NAME = ElasticPersonTest.INDEX_NAME;
    private ElasticsearchBackend backend;
    private IndexOps ops;

    @Before
    public void setupRepository() throws Exception {
        this.ops = new IndexOps(ELASTIC.restClient(), MAPPER, INDEX_NAME);
        this.ops.create(PersonModel.MAPPING).blockingGet();
        this.backend = new ElasticsearchBackend((ElasticsearchSetup)ElasticsearchSetup.builder((RestClient)ELASTIC.restClient()).objectMapper(MAPPER).build());
    }

    @After
    public void tearDown() throws Exception {
        if (this.ops != null) {
            this.ops.delete().blockingGet();
        }
    }

    protected Backend backend() {
        return this.backend;
    }
}

