package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.elasticsearch.client.RestClient;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ElasticsearchSetup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ElasticsearchSetup.Builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableElasticsearchSetup.of()}.
 */
@Generated(from = "ElasticsearchSetup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableElasticsearchSetup
    implements ElasticsearchSetup {
  private final RestClient restClient;
  private final ObjectMapper objectMapper;
  private final IndexResolver resolver;
  private final int scrollSize;

  private ImmutableElasticsearchSetup(RestClient restClient) {
    this.restClient = Objects.requireNonNull(restClient, "restClient");
    this.objectMapper = initShim.objectMapper();
    this.resolver = initShim.resolver();
    this.scrollSize = initShim.scrollSize();
    this.initShim = null;
  }

  private ImmutableElasticsearchSetup(ImmutableElasticsearchSetup.Builder builder) {
    this.restClient = builder.restClient;
    if (builder.objectMapper != null) {
      initShim.objectMapper(builder.objectMapper);
    }
    if (builder.resolver != null) {
      initShim.resolver(builder.resolver);
    }
    if (builder.scrollSizeIsSet()) {
      initShim.scrollSize(builder.scrollSize);
    }
    this.objectMapper = initShim.objectMapper();
    this.resolver = initShim.resolver();
    this.scrollSize = initShim.scrollSize();
    this.initShim = null;
  }

  private ImmutableElasticsearchSetup(
      RestClient restClient,
      ObjectMapper objectMapper,
      IndexResolver resolver,
      int scrollSize) {
    this.restClient = restClient;
    this.objectMapper = objectMapper;
    this.resolver = resolver;
    this.scrollSize = scrollSize;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ElasticsearchSetup", generator = "Immutables")
  private final class InitShim {
    private byte objectMapperBuildStage = STAGE_UNINITIALIZED;
    private ObjectMapper objectMapper;

    ObjectMapper objectMapper() {
      if (objectMapperBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMapperBuildStage == STAGE_UNINITIALIZED) {
        objectMapperBuildStage = STAGE_INITIALIZING;
        this.objectMapper = Objects.requireNonNull(objectMapperInitialize(), "objectMapper");
        objectMapperBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMapper;
    }

    void objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = objectMapper;
      objectMapperBuildStage = STAGE_INITIALIZED;
    }

    private byte resolverBuildStage = STAGE_UNINITIALIZED;
    private IndexResolver resolver;

    IndexResolver resolver() {
      if (resolverBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (resolverBuildStage == STAGE_UNINITIALIZED) {
        resolverBuildStage = STAGE_INITIALIZING;
        this.resolver = Objects.requireNonNull(resolverInitialize(), "resolver");
        resolverBuildStage = STAGE_INITIALIZED;
      }
      return this.resolver;
    }

    void resolver(IndexResolver resolver) {
      this.resolver = resolver;
      resolverBuildStage = STAGE_INITIALIZED;
    }

    private byte scrollSizeBuildStage = STAGE_UNINITIALIZED;
    private int scrollSize;

    int scrollSize() {
      if (scrollSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (scrollSizeBuildStage == STAGE_UNINITIALIZED) {
        scrollSizeBuildStage = STAGE_INITIALIZING;
        this.scrollSize = scrollSizeInitialize();
        scrollSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.scrollSize;
    }

    void scrollSize(int scrollSize) {
      this.scrollSize = scrollSize;
      scrollSizeBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (objectMapperBuildStage == STAGE_INITIALIZING) attributes.add("objectMapper");
      if (resolverBuildStage == STAGE_INITIALIZING) attributes.add("resolver");
      if (scrollSizeBuildStage == STAGE_INITIALIZING) attributes.add("scrollSize");
      return "Cannot build ElasticsearchSetup, attribute initializers form cycle " + attributes;
    }
  }

  private ObjectMapper objectMapperInitialize() {
    return ElasticsearchSetup.super.objectMapper();
  }

  private IndexResolver resolverInitialize() {
    return ElasticsearchSetup.super.resolver();
  }

  private int scrollSizeInitialize() {
    return ElasticsearchSetup.super.scrollSize();
  }

  /**
   * @return The value of the {@code restClient} attribute
   */
  @Override
  public RestClient restClient() {
    return restClient;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper objectMapper() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.objectMapper()
        : this.objectMapper;
  }

  /**
   * @return The value of the {@code resolver} attribute
   */
  @Override
  public IndexResolver resolver() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.resolver()
        : this.resolver;
  }

  /**
   * @return The value of the {@code scrollSize} attribute
   */
  @Override
  public int scrollSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.scrollSize()
        : this.scrollSize;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElasticsearchSetup#restClient() restClient} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for restClient
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElasticsearchSetup withRestClient(RestClient value) {
    if (this.restClient == value) return this;
    RestClient newValue = Objects.requireNonNull(value, "restClient");
    return new ImmutableElasticsearchSetup(newValue, this.objectMapper, this.resolver, this.scrollSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElasticsearchSetup#objectMapper() objectMapper} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objectMapper
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElasticsearchSetup withObjectMapper(ObjectMapper value) {
    if (this.objectMapper == value) return this;
    ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
    return new ImmutableElasticsearchSetup(this.restClient, newValue, this.resolver, this.scrollSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElasticsearchSetup#resolver() resolver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resolver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElasticsearchSetup withResolver(IndexResolver value) {
    if (this.resolver == value) return this;
    IndexResolver newValue = Objects.requireNonNull(value, "resolver");
    return new ImmutableElasticsearchSetup(this.restClient, this.objectMapper, newValue, this.scrollSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElasticsearchSetup#scrollSize() scrollSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scrollSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElasticsearchSetup withScrollSize(int value) {
    if (this.scrollSize == value) return this;
    return new ImmutableElasticsearchSetup(this.restClient, this.objectMapper, this.resolver, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableElasticsearchSetup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableElasticsearchSetup
        && equalTo((ImmutableElasticsearchSetup) another);
  }

  private boolean equalTo(ImmutableElasticsearchSetup another) {
    return restClient.equals(another.restClient)
        && objectMapper.equals(another.objectMapper)
        && resolver.equals(another.resolver)
        && scrollSize == another.scrollSize;
  }

  /**
   * Computes a hash code from attributes: {@code restClient}, {@code objectMapper}, {@code resolver}, {@code scrollSize}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + restClient.hashCode();
    h += (h << 5) + objectMapper.hashCode();
    h += (h << 5) + resolver.hashCode();
    h += (h << 5) + scrollSize;
    return h;
  }

  /**
   * Prints the immutable value {@code ElasticsearchSetup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ElasticsearchSetup")
        .omitNullValues()
        .add("restClient", restClient)
        .add("objectMapper", objectMapper)
        .add("resolver", resolver)
        .add("scrollSize", scrollSize)
        .toString();
  }

  /**
   * Construct a new immutable {@code ElasticsearchSetup} instance.
   * @param restClient The value for the {@code restClient} attribute
   * @return An immutable ElasticsearchSetup instance
   */
  public static ImmutableElasticsearchSetup of(RestClient restClient) {
    return new ImmutableElasticsearchSetup(restClient);
  }

  /**
   * Creates an immutable copy of a {@link ElasticsearchSetup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ElasticsearchSetup instance
   */
  public static ImmutableElasticsearchSetup copyOf(ElasticsearchSetup instance) {
    if (instance instanceof ImmutableElasticsearchSetup) {
      return (ImmutableElasticsearchSetup) instance;
    }
    return new ElasticsearchSetup.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableElasticsearchSetup ImmutableElasticsearchSetup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ElasticsearchSetup", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_REST_CLIENT = 0x1L;
    private static final long OPT_BIT_SCROLL_SIZE = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable RestClient restClient;
    private @Nullable ObjectMapper objectMapper;
    private @Nullable IndexResolver resolver;
    private int scrollSize;

    /**
     * Creates a builder for {@link ImmutableElasticsearchSetup ImmutableElasticsearchSetup} instances.
     * <pre>
     * new ElasticsearchSetup.Builder()
     *    .restClient(org.elasticsearch.client.RestClient) // required {@link ElasticsearchSetup#restClient() restClient}
     *    .objectMapper(com.fasterxml.jackson.databind.ObjectMapper) // optional {@link ElasticsearchSetup#objectMapper() objectMapper}
     *    .resolver(org.immutables.criteria.elasticsearch.IndexResolver) // optional {@link ElasticsearchSetup#resolver() resolver}
     *    .scrollSize(int) // optional {@link ElasticsearchSetup#scrollSize() scrollSize}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ElasticsearchSetup.Builder)) {
        throw new UnsupportedOperationException("Use: new ElasticsearchSetup.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ElasticsearchSetup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final ElasticsearchSetup.Builder from(ElasticsearchSetup instance) {
      Objects.requireNonNull(instance, "instance");
      restClient(instance.restClient());
      objectMapper(instance.objectMapper());
      resolver(instance.resolver());
      scrollSize(instance.scrollSize());
      return (ElasticsearchSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link ElasticsearchSetup#restClient() restClient} attribute.
     * @param restClient The value for restClient 
     * @return {@code this} builder for use in a chained invocation
     */
    public final ElasticsearchSetup.Builder restClient(RestClient restClient) {
      this.restClient = Objects.requireNonNull(restClient, "restClient");
      initBits &= ~INIT_BIT_REST_CLIENT;
      return (ElasticsearchSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link ElasticsearchSetup#objectMapper() objectMapper} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ElasticsearchSetup#objectMapper() objectMapper}.</em>
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final ElasticsearchSetup.Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      return (ElasticsearchSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link ElasticsearchSetup#resolver() resolver} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ElasticsearchSetup#resolver() resolver}.</em>
     * @param resolver The value for resolver 
     * @return {@code this} builder for use in a chained invocation
     */
    public final ElasticsearchSetup.Builder resolver(IndexResolver resolver) {
      this.resolver = Objects.requireNonNull(resolver, "resolver");
      return (ElasticsearchSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link ElasticsearchSetup#scrollSize() scrollSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ElasticsearchSetup#scrollSize() scrollSize}.</em>
     * @param scrollSize The value for scrollSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final ElasticsearchSetup.Builder scrollSize(int scrollSize) {
      this.scrollSize = scrollSize;
      optBits |= OPT_BIT_SCROLL_SIZE;
      return (ElasticsearchSetup.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableElasticsearchSetup ImmutableElasticsearchSetup}.
     * @return An immutable instance of ElasticsearchSetup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableElasticsearchSetup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableElasticsearchSetup(this);
    }

    private boolean scrollSizeIsSet() {
      return (optBits & OPT_BIT_SCROLL_SIZE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REST_CLIENT) != 0) attributes.add("restClient");
      return "Cannot build ElasticsearchSetup, some of required attributes are not set " + attributes;
    }
  }
}
