/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import hu.akarnokd.rxjava2.operators.FlowableTransformers;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.immutables.criteria.elasticsearch.ElasticsearchOps;
import org.immutables.criteria.elasticsearch.Json;
import org.immutables.criteria.elasticsearch.JsonConverter;

class Scrolling<T> {
    private final ElasticsearchOps ops;
    private final JsonConverter<T> converter;
    private final int scrollSize;
    private final Duration keepAlive = Duration.ofMinutes(1L);

    Scrolling(ElasticsearchOps ops, JsonConverter<T> converter) {
        this.ops = ops;
        this.converter = converter;
        this.scrollSize = ops.scrollSize;
    }

    Flowable<T> scroll(ObjectNode query) {
        long limit;
        Map<String, String> params = Collections.singletonMap("scroll", this.keepAlive.getSeconds() + "s");
        boolean hasLimit = query.has("size");
        long l = limit = hasLimit ? query.get("size").asLong() : Long.MAX_VALUE;
        if ((long)this.scrollSize > limit) {
            return this.ops.search(query, this.converter);
        }
        query.put("size", this.scrollSize);
        return this.ops.searchRaw(query, params).toFlowable().scan((Object)AccumulatedResult.empty(limit), AccumulatedResult::next).skip(1L).compose(this.transformer()).map(AccumulatedResult::result).flatMapIterable(r -> r.searchHits().hits()).compose(f -> hasLimit ? f.limit(limit) : f).map(hit -> this.converter.convert((JsonNode)hit.source()));
    }

    private FlowableTransformer<AccumulatedResult, AccumulatedResult> transformer() {
        return FlowableTransformers.expand(r -> r.isLast() ? this.maybeClearScroll(((AccumulatedResult)r).result).toFlowable() : this.ops.nextScroll(((AccumulatedResult)r).result.scrollId().get()).toFlowable().map(r::next));
    }

    private Completable maybeClearScroll(Json.Result result) {
        Objects.requireNonNull(result, "result");
        return result.scrollId().map(scrollId -> this.ops.closeScroll(Collections.singleton(scrollId))).orElse(Completable.complete());
    }

    private static class AccumulatedResult {
        private final long count;
        private final long limit;
        private final Json.Result result;

        private AccumulatedResult(long count, long limit, Json.Result result) {
            this.count = count;
            this.limit = limit;
            this.result = result;
        }

        boolean isLast() {
            Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"result not supposed to be null");
            return this.result.isEmpty() || this.count >= this.limit;
        }

        Json.Result result() {
            return this.result;
        }

        static AccumulatedResult empty(long limit) {
            return new AccumulatedResult(0L, limit, null);
        }

        AccumulatedResult next(Json.Result next) {
            Objects.requireNonNull(next, "next");
            return new AccumulatedResult(this.count + (long)next.searchHits().hits().size(), this.limit, next);
        }
    }
}

