/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class Json {
    Json() {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SearchHit {
        private final String id;
        private final ObjectNode source;

        @JsonCreator
        SearchHit(@JsonProperty(value="_id") String id, @JsonProperty(value="_source") ObjectNode source) {
            this.id = Objects.requireNonNull(id, "id");
            this.source = source;
        }

        public String id() {
            return this.id;
        }

        public ObjectNode source() {
            return this.source;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SearchHits {
        private final List<SearchHit> hits;

        @JsonCreator
        SearchHits(@JsonProperty(value="hits") List<SearchHit> hits) {
            this.hits = Objects.requireNonNull(hits, "hits");
        }

        public List<SearchHit> hits() {
            return this.hits;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Result {
        private final SearchHits hits;
        private final String scrollId;
        private final long took;

        @JsonCreator
        Result(@JsonProperty(value="hits") SearchHits hits, @JsonProperty(value="_scroll_id") String scrollId, @JsonProperty(value="took") long took) {
            this.hits = Objects.requireNonNull(hits, "hits");
            this.scrollId = scrollId;
            this.took = took;
        }

        SearchHits searchHits() {
            return this.hits;
        }

        Duration took() {
            return Duration.ofMillis(this.took);
        }

        Optional<String> scrollId() {
            return Optional.ofNullable(this.scrollId);
        }

        public boolean isEmpty() {
            return this.searchHits().hits().isEmpty();
        }
    }
}

