/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.regex.Pattern;
import org.immutables.criteria.elasticsearch.QueryBuilders;
import org.immutables.criteria.expression.AbstractExpressionVisitor;
import org.immutables.criteria.expression.Call;
import org.immutables.criteria.expression.ComparableOperators;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.expression.Operator;
import org.immutables.criteria.expression.Operators;
import org.immutables.criteria.expression.OptionalOperators;
import org.immutables.criteria.expression.StringOperators;
import org.immutables.criteria.expression.Visitors;

class ElasticsearchQueryVisitor
extends AbstractExpressionVisitor<QueryBuilders.QueryBuilder> {
    ElasticsearchQueryVisitor() {
        super(e -> {
            throw new UnsupportedOperationException();
        });
    }

    public QueryBuilders.QueryBuilder visit(Call call) {
        Operator op = call.operator();
        List args = call.arguments();
        if (op == OptionalOperators.IS_PRESENT || op == OptionalOperators.IS_ABSENT) {
            String field = Visitors.toPath((Expression)((Expression)args.get(0))).toStringPath();
            QueryBuilders.QueryBuilder builder = QueryBuilders.existsQuery(field);
            if (op == OptionalOperators.IS_ABSENT) {
                builder = QueryBuilders.boolQuery().mustNot(builder);
            }
            return builder;
        }
        if (op == Operators.AND || op == Operators.OR) {
            Preconditions.checkArgument((!args.isEmpty() ? 1 : 0) != 0, (String)"Size should be >=1 for %s but was %s", (Object[])new Object[]{op, args.size()});
            QueryBuilders.BoolQueryBuilder builder = args.stream().map(a -> (QueryBuilders.QueryBuilder)a.accept((ExpressionVisitor)this)).reduce(QueryBuilders.boolQuery(), (a, b) -> op == Operators.AND ? a.must((QueryBuilders.QueryBuilder)b) : a.should((QueryBuilders.QueryBuilder)b), (a, b) -> b);
            return builder;
        }
        if (op == Operators.NOT) {
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be 1 for %s but was %s", (Object[])new Object[]{op, args.size()});
            QueryBuilders.QueryBuilder builder = (QueryBuilders.QueryBuilder)((Expression)args.get(0)).accept((ExpressionVisitor)this);
            return QueryBuilders.boolQuery().mustNot(builder);
        }
        if (op.arity() == Operator.Arity.BINARY) {
            return this.binaryCall(call);
        }
        throw new UnsupportedOperationException("Don't know how to handle " + call);
    }

    private QueryBuilders.QueryBuilder binaryCall(Call call) {
        List arguments = call.arguments();
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (String)"Size should be 2 for %s but was %s", (Object[])new Object[]{call.operator(), arguments.size()});
        Operator op = call.operator();
        String field = Visitors.toPath((Expression)((Expression)arguments.get(0))).toStringPath();
        Object value = Visitors.toConstant((Expression)((Expression)arguments.get(1))).value();
        if (op == Operators.EQUAL || op == Operators.NOT_EQUAL) {
            QueryBuilders.QueryBuilder term = QueryBuilders.termQuery(field, value);
            if (op == Operators.NOT_EQUAL) {
                QueryBuilders.BoolQueryBuilder bool = QueryBuilders.boolQuery().mustNot(term);
                if ("".equals(value)) {
                    bool = bool.should(QueryBuilders.existsQuery(field));
                }
                term = bool;
            }
            return term;
        }
        if (op == Operators.IN || op == Operators.NOT_IN) {
            List values = Visitors.toConstant((Expression)((Expression)arguments.get(1))).values();
            QueryBuilders.QueryBuilder builder = QueryBuilders.termsQuery(field, values);
            if (op == Operators.NOT_IN) {
                builder = QueryBuilders.boolQuery().mustNot(builder);
            }
            return builder;
        }
        if (ComparableOperators.isComparable((Operator)op)) {
            QueryBuilders.RangeQueryBuilder builder = QueryBuilders.rangeQuery(field);
            if (op == ComparableOperators.GREATER_THAN) {
                builder.gt(value);
            } else if (op == ComparableOperators.GREATER_THAN_OR_EQUAL) {
                builder.gte(value);
            } else if (op == ComparableOperators.LESS_THAN) {
                builder.lt(value);
            } else if (op == ComparableOperators.LESS_THAN_OR_EQUAL) {
                builder.lte(value);
            } else {
                throw new UnsupportedOperationException("Unknown comparison " + call);
            }
            return builder;
        }
        if (op == StringOperators.STARTS_WITH) {
            return QueryBuilders.prefixQuery(field, value.toString());
        }
        if (op == StringOperators.MATCHES) {
            Preconditions.checkArgument((boolean)(value instanceof Pattern), (String)"%s is not regex pattern", (Object[])new Object[]{value});
            return QueryBuilders.regexpQuery(field, ((Pattern)value).pattern());
        }
        if (op == StringOperators.ENDS_WITH || op == StringOperators.CONTAINS) {
            return QueryBuilders.wildcardQuery(field, "*" + value.toString() + (op == StringOperators.CONTAINS ? "*" : ""));
        }
        throw new UnsupportedOperationException(String.format("Call %s not supported", call));
    }
}

