/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.elasticsearch.Json;
import org.immutables.criteria.elasticsearch.JsonConverter;
import org.immutables.criteria.elasticsearch.Scrolling;

class ElasticsearchOps {
    private final RestClient restClient;
    private final ObjectMapper mapper;
    private final String index;
    final int scrollSize;

    ElasticsearchOps(RestClient restClient, String index, ObjectMapper mapper, int scrollSize) {
        this.restClient = Objects.requireNonNull(restClient, "restClient");
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.index = Objects.requireNonNull(index, "index");
        Preconditions.checkArgument((scrollSize > 0 ? 1 : 0) != 0, (String)"Invalid scrollSize: %s", (Object[])new Object[]{scrollSize});
        this.scrollSize = scrollSize;
    }

    void createIndex(Map<String, String> mapping) throws IOException {
        Objects.requireNonNull(this.index, "index");
        Objects.requireNonNull(mapping, "mapping");
        ObjectNode mappings = this.mapper().createObjectNode();
        ObjectNode properties = mappings.with("mappings").with("properties");
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            ElasticsearchOps.applyMapping(properties, entry.getKey(), entry.getValue());
        }
        StringEntity entity = new StringEntity(this.mapper().writeValueAsString((Object)mappings), ContentType.APPLICATION_JSON);
        Request r = new Request("PUT", "/" + this.index);
        r.setEntity((HttpEntity)entity);
        this.restClient().performRequest(r);
    }

    void deleteIndex() throws IOException {
        Request r = new Request("DELETE", "/" + this.index);
        this.restClient().performRequest(r);
    }

    private static void applyMapping(ObjectNode parent, String key, String type) {
        int index = key.indexOf(46);
        if (index > -1) {
            String prefix = key.substring(0, index);
            String suffix = key.substring(index + 1, key.length());
            ElasticsearchOps.applyMapping(parent.with(prefix).with("properties"), suffix, type);
        } else {
            parent.with(key).put("type", type);
        }
    }

    void insertDocument(ObjectNode document) throws IOException {
        Objects.requireNonNull(this.index, "index");
        Objects.requireNonNull(document, "document");
        String uri = String.format(Locale.ROOT, "/%s/_doc?refresh", this.index);
        StringEntity entity = new StringEntity(this.mapper().writeValueAsString((Object)document), ContentType.APPLICATION_JSON);
        Request r = new Request("POST", uri);
        r.setEntity((HttpEntity)entity);
        this.restClient().performRequest(r);
    }

    void insertBulk(List<ObjectNode> documents) throws IOException {
        Objects.requireNonNull(documents, "documents");
        if (documents.isEmpty()) {
            return;
        }
        ArrayList<String> bulk = new ArrayList<String>(documents.size() * 2);
        for (ObjectNode doc : documents) {
            ObjectNode header = this.mapper.createObjectNode();
            header.with("index").put("_index", this.index);
            if (doc.has("_id")) {
                header.with("index").set("_id", doc.get("_id"));
                doc.remove("_id");
            }
            bulk.add(header.toString());
            bulk.add(this.mapper().writeValueAsString((Object)doc));
        }
        StringEntity entity = new StringEntity(String.join((CharSequence)"\n", bulk) + "\n", ContentType.APPLICATION_JSON);
        Request r = new Request("POST", "/_bulk?refresh");
        r.setEntity((HttpEntity)entity);
        this.restClient().performRequest(r);
    }

    <T> Function<JsonNode, T> jsonConverter(Class<T> type) {
        return json -> {
            try {
                return this.mapper.treeToValue((TreeNode)json, type);
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        };
    }

    <T> Function<Response, Json.Result> responseConverter() {
        return response -> {
            try (InputStream is = response.getEntity().getContent();){
                Json.Result result = (Json.Result)this.mapper.readValue(is, Json.Result.class);
                return result;
            }
            catch (IOException e) {
                String message = String.format("Couldn't parse HTTP response %s into %s", response, Json.Result.class.getSimpleName());
                throw new UncheckedIOException(message, e);
            }
        };
    }

    <T> Flowable<T> scrolledSearch(ObjectNode query, JsonConverter<T> converter) {
        return new Scrolling<T>(this, converter).scroll(query);
    }

    Single<Json.Result> nextScroll(String scrollId) {
        Request request = new Request("POST", "/_search/scroll");
        ObjectNode payload = this.mapper.createObjectNode().put("scroll", "1m").put("scroll_id", scrollId);
        request.setJsonEntity(payload.toString());
        return this.rawHttp(request).map(r -> this.responseConverter().apply((Response)r));
    }

    Completable closeScroll(Iterable<String> scrollIds) {
        ObjectNode payload = this.mapper.createObjectNode();
        ArrayNode array = payload.withArray("scroll_id");
        scrollIds.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        Request request = new Request("DELETE", "/_search/scroll");
        request.setJsonEntity(payload.toString());
        return this.rawHttp(request).ignoreElement();
    }

    <T> Flowable<T> search(ObjectNode query, JsonConverter<T> converter) {
        return this.searchRaw(query, Collections.emptyMap()).toFlowable().flatMapIterable(r -> r.searchHits().hits()).map(x -> converter.convert((JsonNode)x.source()));
    }

    Single<Json.Result> searchRaw(ObjectNode query, Map<String, String> httpParams) {
        Request request = new Request("POST", String.format("/%s/_search", this.index));
        httpParams.forEach((arg_0, arg_1) -> ((Request)request).addParameter(arg_0, arg_1));
        request.setJsonEntity(query.toString());
        return this.rawHttp(request).map(r -> this.responseConverter().apply((Response)r));
    }

    Single<Response> rawHttp(Request request) {
        return Single.create(source -> this.restClient.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                source.onSuccess((Object)response);
            }

            public void onFailure(Exception exception) {
                source.onError((Throwable)exception);
            }
        }));
    }

    ObjectMapper mapper() {
        return this.mapper;
    }

    private RestClient restClient() {
        return this.restClient;
    }
}

