/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.reactivex.Flowable;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.Backends;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.elasticsearch.DefaultConverter;
import org.immutables.criteria.elasticsearch.Elasticsearch;
import org.immutables.criteria.elasticsearch.ElasticsearchOps;
import org.immutables.criteria.elasticsearch.IndexResolver;
import org.immutables.criteria.elasticsearch.JsonConverter;
import org.immutables.criteria.elasticsearch.ToTupleConverter;
import org.immutables.criteria.expression.Query;
import org.reactivestreams.Publisher;

public class ElasticsearchBackend
implements Backend {
    final RestClient restClient;
    final ObjectMapper mapper;
    private final IndexResolver resolver;
    private final int scrollSize;

    public ElasticsearchBackend(RestClient restClient, ObjectMapper mapper, IndexResolver resolver) {
        this(restClient, mapper, resolver, 1024);
    }

    ElasticsearchBackend(RestClient restClient, ObjectMapper mapper, IndexResolver resolver, int scrollSize) {
        this.restClient = Objects.requireNonNull(restClient, "restClient");
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.scrollSize = scrollSize;
    }

    public Backend.Session open(Class<?> entityType) {
        Object index = this.resolver.resolve((Class)entityType);
        return new Session(entityType, new ElasticsearchOps(this.restClient, (String)index, this.mapper, this.scrollSize));
    }

    private static class Session
    implements Backend.Session {
        private final ObjectMapper mapper;
        private final ElasticsearchOps ops;
        private final Function<Object, Object> idExtractor;
        private final JsonConverter<Object> converter;
        private final boolean hasId;

        private Session(Class<?> entityClass, ElasticsearchOps ops) {
            Objects.requireNonNull(entityClass, "entityClass");
            this.ops = Objects.requireNonNull(ops, "ops");
            this.mapper = ops.mapper();
            Function idExtractor = Function.identity();
            boolean hasId = false;
            try {
                idExtractor = Backends.idExtractor(entityClass);
                hasId = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.idExtractor = idExtractor;
            this.converter = DefaultConverter.of(this.mapper, entityClass);
            this.hasId = hasId;
        }

        public <T> Publisher<T> execute(Backend.Operation query) {
            Objects.requireNonNull(query, "query");
            if (query instanceof StandardOperations.Insert) {
                return this.insert((StandardOperations.Insert<Object>)((StandardOperations.Insert)query));
            }
            if (query instanceof StandardOperations.Select) {
                return this.select((StandardOperations.Select)query);
            }
            return Flowable.error((Throwable)new UnsupportedOperationException(String.format("Op %s not supported", query)));
        }

        private <T> Flowable<T> select(StandardOperations.Select<T> op) {
            Query query = op.query();
            if (!query.groupBy().isEmpty()) {
                throw new UnsupportedOperationException("GroupBy not supported by " + ElasticsearchBackend.class.getSimpleName());
            }
            ObjectNode json = query.filter().map(f -> (ObjectNode)Elasticsearch.converter(this.mapper).convert(f)).orElseGet(() -> ((ObjectMapper)this.mapper).createObjectNode());
            query.limit().ifPresent(limit -> json.put("size", limit));
            query.offset().ifPresent(offset -> json.put("from", offset));
            if (!query.collations().isEmpty()) {
                ArrayNode sort = json.withArray("sort");
                query.collations().forEach(c -> sort.add((JsonNode)this.mapper.createObjectNode().put(c.path().toStringPath(), c.direction().isAscending() ? "asc" : "desc")));
            }
            ToTupleConverter converter = this.converter;
            if (!query.projections().isEmpty()) {
                converter = new ToTupleConverter(query, this.mapper);
            }
            Flowable<ProjectedTuple> flowable = query.offset().isPresent() ? this.ops.search(json, converter) : this.ops.scrolledSearch(json, converter);
            return flowable;
        }

        private Publisher<WriteResult> insert(StandardOperations.Insert<Object> insert) {
            if (insert.values().isEmpty()) {
                return Flowable.just((Object)WriteResult.empty());
            }
            BiFunction<Object, ObjectNode, ObjectNode> idFn = (entity, node) -> this.hasId ? (ObjectNode)node.set("_id", this.mapper.valueToTree(this.idExtractor.apply(entity))) : node;
            List docs = insert.values().stream().map(e -> (ObjectNode)idFn.apply(e, (ObjectNode)this.mapper.valueToTree(e))).collect(Collectors.toList());
            return Flowable.fromCallable(() -> {
                this.ops.insertBulk(docs);
                return WriteResult.unknown();
            });
        }
    }
}

