/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import io.reactivex.Observable;
import io.reactivex.observers.TestObserver;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.elasticsearch.ElasticModelCriteria;
import org.immutables.criteria.elasticsearch.ElasticModelRepository;
import org.immutables.criteria.elasticsearch.ElasticPersonTest;
import org.immutables.criteria.elasticsearch.ElasticsearchBackend;
import org.immutables.criteria.elasticsearch.ElasticsearchOps;
import org.immutables.criteria.elasticsearch.EmbeddedElasticsearchResource;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.reactivestreams.Publisher;

public class ElasticModelTest {
    @ClassRule
    public static final EmbeddedElasticsearchResource RESOURCE = EmbeddedElasticsearchResource.create();
    private static final ObjectMapper MAPPER = ElasticPersonTest.MAPPER;
    private static final String INDEX_NAME = "mymodel";
    private ElasticModelRepository repository;

    @BeforeClass
    public static void setupElastic() throws Exception {
        ElasticsearchOps ops = new ElasticsearchOps(RESOURCE.restClient(), INDEX_NAME, MAPPER, 1024);
        ImmutableMap model = ImmutableMap.builder().put((Object)"string", (Object)"keyword").put((Object)"optionalString", (Object)"keyword").put((Object)"bool", (Object)"boolean").put((Object)"intNumber", (Object)"integer").build();
        ops.createIndex((Map)model);
        ObjectNode doc1 = MAPPER.createObjectNode().put("string", "foo").put("optionalString", "optFoo").put("bool", true).put("intNumber", 42);
        ObjectNode doc2 = MAPPER.createObjectNode().put("string", "bar").put("optionalString", "optBar").put("bool", false).put("intNumber", 44);
        ops.insertBulk(Arrays.asList(doc1, doc2));
    }

    @Before
    public void setupRepository() throws Exception {
        ElasticsearchBackend backend = new ElasticsearchBackend(RESOURCE.restClient(), MAPPER, x -> INDEX_NAME);
        this.repository = new ElasticModelRepository((Backend)backend);
    }

    @Test
    public void criteria() {
        ElasticModelCriteria crit = ElasticModelCriteria.elasticModel;
        this.assertCount(crit, 2);
        this.assertCount((ElasticModelCriteria)((Object)crit.intNumber.is((Object)1)), 0);
        this.assertCount((ElasticModelCriteria)((Object)crit.string.is((Object)"foo")), 1);
        this.assertCount((ElasticModelCriteria)((Object)crit.string.in((Object)"foo", (Object)"bar", (Object[])new String[0])), 2);
        this.assertCount((ElasticModelCriteria)((Object)crit.string.notIn((Object)"foo", (Object)"bar", (Object[])new String[0])), 0);
        this.assertCount((ElasticModelCriteria)((Object)crit.string.in((Object)"foo", (Object)"foo2", (Object[])new String[0])), 1);
        this.assertCount((ElasticModelCriteria)((Object)crit.string.in((Object)"not", (Object)"not", (Object[])new String[0])), 0);
        this.assertCount((ElasticModelCriteria)((Object)crit.string.is((Object)"bar")), 1);
        this.assertCount((ElasticModelCriteria)((Object)crit.string.is((Object)"hello")), 0);
        this.assertCount((ElasticModelCriteria)((Object)crit.optionalString.is((Object)"optFoo")), 1);
        this.assertCount((ElasticModelCriteria)((Object)crit.optionalString.is((Object)"missing")), 0);
        this.assertCount((ElasticModelCriteria)((Object)((ElasticModelCriteria)((Object)crit.intNumber.atMost((Comparable)Integer.valueOf((int)42)))).string.is((Object)"foo")), 1);
        this.assertCount((ElasticModelCriteria)((Object)crit.intNumber.atMost((Comparable)Integer.valueOf(11))), 0);
    }

    private void assertCount(ElasticModelCriteria crit, int count) {
        ((TestObserver)Observable.fromPublisher((Publisher)this.repository.find(crit).fetch()).test().awaitDone(1L, TimeUnit.SECONDS)).assertValueCount(count);
    }
}

