/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.criteria.Criterion;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.elasticsearch.ElasticModel;
import org.immutables.criteria.repository.Repository;
import org.immutables.criteria.repository.reactive.ReactiveReadable;
import org.immutables.criteria.repository.reactive.ReactiveReader;
import org.immutables.criteria.repository.reactive.ReactiveRepository;
import org.immutables.criteria.repository.reactive.ReactiveWritable;
import org.reactivestreams.Publisher;

@ThreadSafe
public class ElasticModelRepository
implements Repository<ElasticModel>,
ReactiveRepository.Readable<ElasticModel>,
ReactiveRepository.Writable<ElasticModel> {
    private final Backend backend;
    private final ReactiveReadable<ElasticModel> readable;
    private final ReactiveWritable<ElasticModel> writable;

    public ElasticModelRepository(Backend backend) {
        this.backend = Objects.requireNonNull(backend, "backend");
        Backend.Session session = backend.open(ElasticModel.class);
        this.readable = new ReactiveReadable(ElasticModel.class, session);
        this.writable = new ReactiveWritable(session);
    }

    public ReactiveReader<ElasticModel> find(Criterion<ElasticModel> arg0) {
        return this.readable.find(arg0);
    }

    public ReactiveReader<ElasticModel> findAll() {
        return this.readable.findAll();
    }

    public Publisher<WriteResult> insert(ElasticModel ... docs) {
        return (Publisher)this.writable.insert((Object[])docs);
    }

    public Publisher<WriteResult> insert(Iterable<? extends ElasticModel> arg0) {
        return this.writable.insert(arg0);
    }

    public Publisher<WriteResult> delete(Criterion<ElasticModel> arg0) {
        return this.writable.delete(arg0);
    }
}

