/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.maven.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.ibboost.orqa.maven.domain.OrqaExecution;
import org.ibboost.orqa.maven.services.OrqaExecutionResult;
import org.ibboost.orqa.maven.utils.OutputHandler;

public class OrqaExecutionService {
    private OutputHandler outputHandler;
    private OutputHandler errorHandler;

    public OrqaExecutionService(OutputHandler outputHandler, OutputHandler errorHandler) {
        this.outputHandler = outputHandler;
        this.errorHandler = errorHandler;
    }

    public OrqaExecutionResult execute(OrqaExecution execution) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(execution.getOrqaHome());
        ArrayList<String> command = new ArrayList<String>();
        command.add(execution.getExecutablePath());
        command.add("run");
        command.add(execution.getTaskPath());
        Map<String, String> taskParams = execution.getTaskParams();
        if (taskParams != null && taskParams.size() > 0) {
            for (Map.Entry<String, String> entry : taskParams.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getKey()).append("=").append(entry.getValue());
                command.add(sb.toString());
            }
        }
        command.add("--verbose");
        pb.command(command);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        try {
            Process p = pb.start();
            this.outputHandler.setInputStream(p.getInputStream());
            this.errorHandler.setInputStream(p.getErrorStream());
            Thread outputThread = new Thread(this.outputHandler);
            Thread errorThread = new Thread(this.errorHandler);
            outputThread.start();
            errorThread.start();
            p.waitFor();
            int exitCode = p.exitValue();
            if (exitCode == 0) {
                return OrqaExecutionResult.success("ORQA task ran successfully");
            }
            return OrqaExecutionResult.failure("ORQA task failed");
        }
        catch (IOException | InterruptedException e) {
            return OrqaExecutionResult.failure("Technical error occurred running the ORQA script", e);
        }
    }
}

