/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.maven;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.ibboost.orqa.maven.domain.OrqaExecution;
import org.ibboost.orqa.maven.services.OrqaExecutionResult;
import org.ibboost.orqa.maven.services.OrqaExecutionService;
import org.ibboost.orqa.maven.utils.OutputHandler;

@Mojo(name="execute", defaultPhase=LifecyclePhase.INTEGRATION_TEST)
public class ExecuteMojo
extends AbstractMojo {
    private static final String ORQA_HOME_PROPERTY = "ORQA_HOME";
    @Parameter(property="execute.orqaHome")
    private File orqaHome;
    @Parameter(property="execute.task", required=true)
    private String task;
    @Parameter
    private Map<String, String> taskParams;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.orqaHome == null) {
            this.orqaHome = this.getDefaultOrqaHome();
        }
        if (this.orqaHome == null) {
            this.reportError("ORQA Home is not set. Either set the orqaHome plugin parameter or the ORQA_HOME environment variable");
        }
        if (!this.orqaHome.exists() || !this.orqaHome.isDirectory()) {
            this.reportError("The configured ORQA location is not a valid directory. [" + this.orqaHome + "]");
        }
        OrqaExecution execution = new OrqaExecution(this.orqaHome, this.task, this.taskParams);
        this.getLog().info((CharSequence)("Using ORQA distribution in " + this.orqaHome.getAbsolutePath()));
        this.getLog().info((CharSequence)("Executing task " + this.task));
        if (this.taskParams != null && this.taskParams.size() > 0) {
            this.getLog().info((CharSequence)"Task parameters are:");
            for (Map.Entry<String, String> param : this.taskParams.entrySet()) {
                this.getLog().info((CharSequence)(param.getKey() + ": " + param.getValue()));
            }
        } else {
            this.getLog().info((CharSequence)"No task parameters specified");
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Launching ORQA...");
        this.getLog().info((CharSequence)"");
        OutputHandler outputHandler = OutputHandler.createOutputHandler(this.getLog());
        OutputHandler errorHandler = OutputHandler.createErrorHandler(this.getLog());
        OrqaExecutionService orqaService = new OrqaExecutionService(outputHandler, errorHandler);
        OrqaExecutionResult result = orqaService.execute(execution);
        if (!result.getSuccess().booleanValue()) {
            if (result.getException() != null) {
                throw new MojoFailureException(result.getMessage(), result.getException());
            }
            throw new MojoFailureException(result.getMessage());
        }
    }

    private void reportError(String msg) throws MojoFailureException {
        this.getLog().error((CharSequence)msg);
        throw new MojoFailureException(msg);
    }

    private File getDefaultOrqaHome() {
        String orqaHomeEnv = System.getenv(ORQA_HOME_PROPERTY);
        if (orqaHomeEnv != null) {
            this.getLog().info((CharSequence)"Using ORQA_HOME environment variable");
            this.getLog().info((CharSequence)("ORQA_HOME: " + orqaHomeEnv));
            return new File(orqaHomeEnv);
        }
        return null;
    }
}

