/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.grinder;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.grinder.GrinderBuildAction;
import hudson.plugins.grinder.GrinderParseException;
import hudson.plugins.grinder.GrinderProjectAction;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrinderPublisher
extends Recorder {
    private String name;

    @DataBoundConstructor
    public GrinderPublisher(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getWorkspace().child(this.name).exists()) {
            InputStream is = build.getWorkspace().child(this.name).read();
            try {
                build.addAction((Action)new GrinderBuildAction(build, is, logger));
            }
            catch (GrinderParseException gpe) {
                logger.println("Grinder report failed!");
                build.setResult(Result.FAILURE);
            }
        } else {
            logger.println("Grinder out* log file not found!");
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return project instanceof Project ? new GrinderProjectAction((Project)project) : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

