/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.grinder;

import hudson.model.AbstractBuild;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.grinder.AbstractGrinderAction;
import hudson.plugins.grinder.GrinderBuildAction;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GrinderProjectAction
extends AbstractGrinderAction {
    private final Project project;

    public GrinderProjectAction(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public GrinderBuildAction getActionByBuildNumber(int number) {
        return (GrinderBuildAction)this.project.getBuildByNumber(number).getAction(GrinderBuildAction.class);
    }

    public void doMeanTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.shouldReloadGraph(request, response)) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createMeanTimeGraph(), (int)800, (int)150);
        }
    }

    public void doStdDevGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.shouldReloadGraph(request, response)) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createStdDevGraph(), (int)800, (int)150);
        }
    }

    public void doMeanRespLengthGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.shouldReloadGraph(request, response)) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createMeanRespLengthGraph(), (int)800, (int)150);
        }
    }

    private JFreeChart createMeanTimeGraph() {
        return this.createNumberBuildGraph("Mean Test Time", "Time (ms)");
    }

    private JFreeChart createStdDevGraph() {
        return this.createNumberBuildGraph("Test Time Standard Deviation", "Time (ms)");
    }

    private JFreeChart createMeanRespLengthGraph() {
        return this.createNumberBuildGraph("Mean Response Length", "Length (bytes)");
    }

    private JFreeChart createNumberBuildGraph(String valueName, String unitName) {
        DataSetBuilder builder = new DataSetBuilder();
        for (Object build : this.project.getBuilds()) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.SUCCESS)) continue;
            GrinderBuildAction action = (GrinderBuildAction)abstractBuild.getAction(GrinderBuildAction.class);
            builder.add(action.getTotals().getValue(valueName), (Comparable)((Object)valueName), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
        }
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)(valueName + " Trend"), (String)"Build", (String)unitName, (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private boolean shouldReloadGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        return this.shouldReloadGraph(request, response, this.project.getLastSuccessfulBuild());
    }
}

