/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.user;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.favorite.user.FavoriteUserPropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class FavoriteUserProperty
extends UserProperty {
    @Extension
    public static final UserPropertyDescriptor DESCRIPTOR = new FavoriteUserPropertyDescriptor();
    private List<String> favorites = new ArrayList();

    @DataBoundConstructor
    public FavoriteUserProperty() {
        this.getDescriptor();
    }

    public List<String> getFavorites() {
        return this.favorites;
    }

    public void addFavorite(String job) throws IOException {
        this.favorites.add(job);
        this.user.save();
    }

    public void removeFavorite(String job) throws IOException {
        this.favorites.remove(job);
        this.user.save();
    }

    public void toggleFavorite(String job) throws IOException {
        if (this.isJobFavorite(job)) {
            this.removeFavorite(job);
        } else {
            this.addFavorite(job);
        }
    }

    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return this;
    }

    public boolean isJobFavorite(String job) {
        return this.favorites.contains(job);
    }

    public UserPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }
}

