/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite;

import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import java.io.IOException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.security.core.Authentication;

public class FavoritePlugin
extends Plugin {
    public void doToggleFavorite(StaplerRequest req, StaplerResponse resp, @QueryParameter String job, @QueryParameter String userName, @QueryParameter Boolean redirect) throws IOException {
        if ("".equals(userName) || userName == null) {
            Authentication authentication = Hudson.getAuthentication();
            userName = authentication.getName();
        }
        if (!userName.equals("anonymous")) {
            User user = Hudson.getInstance().getUser(userName);
            FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
            try {
                if (fup == null) {
                    user.addProperty((UserProperty)new FavoriteUserProperty());
                    fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
                }
                fup.toggleFavorite(job);
                user.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (redirect.booleanValue()) {
            resp.sendRedirect(resp.encodeRedirectURL("/job/" + job));
        }
    }
}

