/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.project;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.favorite.Messages;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.security.Authentication;

public class FavoriteProjectAction
implements Action {
    private final AbstractProject<?, ?> project;

    public FavoriteProjectAction(AbstractProject project) {
        this.project = project;
    }

    public String getProjectName() {
        return this.project.getDisplayName();
    }

    public String getIconFileName() {
        if (this.hasPermission()) {
            if (this.isFavorite()) {
                return "star-gold.gif";
            }
            return "star.gif";
        }
        return null;
    }

    public String getDisplayName() {
        if (this.hasPermission()) {
            return Messages.favoriteColumn();
        }
        return null;
    }

    public String getUrlName() {
        if (this.hasPermission()) {
            try {
                return "/plugin/favorite/toggleFavorite?job=" + URLEncoder.encode(this.getProjectName(), "UTF-8") + "&userName=" + URLEncoder.encode(this.getUserName(), "UTF-8") + "&redirect=true";
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    private boolean hasPermission() {
        Authentication authentication = Hudson.getAuthentication();
        String userName = authentication.getName();
        return !userName.equals("anonymous");
    }

    private String getUserName() {
        Authentication authentication = Hudson.getAuthentication();
        return authentication.getName();
    }

    private boolean isFavorite() {
        Authentication authentication = Hudson.getAuthentication();
        String userName = authentication.getName();
        if (!userName.equals("anonymous")) {
            User user = Hudson.getInstance().getUser(userName);
            FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
            return fup.isJobFavorite(this.project.getDisplayName());
        }
        return false;
    }
}

