/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.listener;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.User;
import hudson.model.listeners.ItemListener;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import java.io.IOException;

@Extension
public class FavoriteJobListener
extends ItemListener {
    public void onRenamed(Item item, String oldName, String newName) {
        if (item instanceof AbstractProject) {
            for (User user : User.getAll()) {
                FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
                try {
                    if (fup == null || !fup.isJobFavorite(oldName)) continue;
                    fup.removeFavorite(oldName);
                    fup.addFavorite(newName);
                    user.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onDeleted(Item item) {
        if (item instanceof AbstractProject) {
            for (User user : User.getAll()) {
                FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
                try {
                    if (fup == null || !fup.isJobFavorite(item.getName())) continue;
                    fup.removeFavorite(item.getName());
                    user.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

