/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.lhapi.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class AccessToken {
    private String accessToken = null;
    private TokenTypeEnum tokenType = null;
    private Integer expiresIn = null;

    @ApiModelProperty(required=true, value="Your new access token")
    @JsonProperty(value="access_token")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @ApiModelProperty(required=true, value="Type of the token. We only use bearer tokens. Note that we respond with token_type \"bearer\" (lower case b) yet when you send us a token it must be named \"Bearer\" (upper case B).")
    @JsonProperty(value="token_type")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    @ApiModelProperty(required=true, value="The number of seconds until this token expires")
    @JsonProperty(value="expires_in")
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken accessToken = (AccessToken)o;
        return Objects.equals(accessToken, accessToken.accessToken) && Objects.equals((Object)this.tokenType, (Object)accessToken.tokenType) && Objects.equals(this.expiresIn, accessToken.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessToken, this.tokenType, this.expiresIn});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessToken {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenTypeEnum {
        BEARER("bearer");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

