/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.lhapi.client.api;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import org.hisrc.lhapi.client.invoker.ApiClient;
import org.hisrc.lhapi.client.invoker.ApiException;
import org.hisrc.lhapi.client.invoker.Configuration;
import org.hisrc.lhapi.client.invoker.Pair;
import org.hisrc.lhapi.client.model.AccessToken;
import org.hisrc.lhapi.client.model.AircraftSummariesResponse;
import org.hisrc.lhapi.client.model.AirlinesResponse;
import org.hisrc.lhapi.client.model.AirportsResponse;
import org.hisrc.lhapi.client.model.CitiesResponse;
import org.hisrc.lhapi.client.model.CountriesResponse;
import org.hisrc.lhapi.client.model.FlightStatusResponse;
import org.hisrc.lhapi.client.model.FlightsStatusResponse;
import org.hisrc.lhapi.client.model.NearestAirportsResponse;

public class DefaultApi {
    private ApiClient apiClient;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AccessToken oauthTokenPost(String clientId, String clientSecret, String grantType) throws ApiException {
        Object postBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling oauthTokenPost");
        }
        if (clientSecret == null) {
            throw new ApiException(400, "Missing the required parameter 'clientSecret' when calling oauthTokenPost");
        }
        if (grantType == null) {
            throw new ApiException(400, "Missing the required parameter 'grantType' when calling oauthTokenPost");
        }
        String path = "/oauth/token".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (clientId != null) {
            formParams.put("client_id", clientId);
        }
        if (clientSecret != null) {
            formParams.put("client_secret", clientSecret);
        }
        if (grantType != null) {
            formParams.put("grant_type", grantType);
        }
        String[] accepts = new String[]{};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/x-www-form-urlencoded"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<AccessToken> returnType = new GenericType<AccessToken>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public FlightsStatusResponse operationsFlightstatusArrivalsAirportCodeFromUntilGet(String airportCode, String from, String until) throws ApiException {
        Object postBody = null;
        if (airportCode == null) {
            throw new ApiException(400, "Missing the required parameter 'airportCode' when calling operationsFlightstatusArrivalsAirportCodeFromUntilGet");
        }
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling operationsFlightstatusArrivalsAirportCodeFromUntilGet");
        }
        if (until == null) {
            throw new ApiException(400, "Missing the required parameter 'until' when calling operationsFlightstatusArrivalsAirportCodeFromUntilGet");
        }
        String path = "/operations/flightstatus/arrivals/{airportCode}/{from}/{until}".replaceAll("\\{format\\}", "json").replaceAll("\\{airportCode\\}", this.apiClient.escapeString(airportCode.toString())).replaceAll("\\{from\\}", this.apiClient.escapeString(from.toString())).replaceAll("\\{until\\}", this.apiClient.escapeString(until.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<FlightsStatusResponse> returnType = new GenericType<FlightsStatusResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public FlightsStatusResponse operationsFlightstatusDeparturesAirportCodeFromUntilGet(String airportCode, String from, String until) throws ApiException {
        Object postBody = null;
        if (airportCode == null) {
            throw new ApiException(400, "Missing the required parameter 'airportCode' when calling operationsFlightstatusDeparturesAirportCodeFromUntilGet");
        }
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling operationsFlightstatusDeparturesAirportCodeFromUntilGet");
        }
        if (until == null) {
            throw new ApiException(400, "Missing the required parameter 'until' when calling operationsFlightstatusDeparturesAirportCodeFromUntilGet");
        }
        String path = "/operations/flightstatus/departures/{airportCode}/{from}/{until}".replaceAll("\\{format\\}", "json").replaceAll("\\{airportCode\\}", this.apiClient.escapeString(airportCode.toString())).replaceAll("\\{from\\}", this.apiClient.escapeString(from.toString())).replaceAll("\\{until\\}", this.apiClient.escapeString(until.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<FlightsStatusResponse> returnType = new GenericType<FlightsStatusResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public FlightStatusResponse operationsFlightstatusFlightNumberDateGet(String flightNumber, String date) throws ApiException {
        Object postBody = null;
        if (flightNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'flightNumber' when calling operationsFlightstatusFlightNumberDateGet");
        }
        if (date == null) {
            throw new ApiException(400, "Missing the required parameter 'date' when calling operationsFlightstatusFlightNumberDateGet");
        }
        String path = "/operations/flightstatus/{flightNumber}/{date}".replaceAll("\\{format\\}", "json").replaceAll("\\{flightNumber\\}", this.apiClient.escapeString(flightNumber.toString())).replaceAll("\\{date\\}", this.apiClient.escapeString(date.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<FlightStatusResponse> returnType = new GenericType<FlightStatusResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AircraftSummariesResponse referencesAircraftGet() throws ApiException {
        Object postBody = null;
        String path = "/references/aircraft/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<AircraftSummariesResponse> returnType = new GenericType<AircraftSummariesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AircraftSummariesResponse referencesAircraftAircraftCodeGet(String aircraftCode) throws ApiException {
        Object postBody = null;
        if (aircraftCode == null) {
            throw new ApiException(400, "Missing the required parameter 'aircraftCode' when calling referencesAircraftAircraftCodeGet");
        }
        String path = "/references/aircraft/{aircraftCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{aircraftCode\\}", this.apiClient.escapeString(aircraftCode.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<AircraftSummariesResponse> returnType = new GenericType<AircraftSummariesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AirlinesResponse referencesAirlinesGet() throws ApiException {
        Object postBody = null;
        String path = "/references/airlines/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<AirlinesResponse> returnType = new GenericType<AirlinesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AirlinesResponse referencesAirlinesAirlineCodeGet(String airlineCode) throws ApiException {
        Object postBody = null;
        if (airlineCode == null) {
            throw new ApiException(400, "Missing the required parameter 'airlineCode' when calling referencesAirlinesAirlineCodeGet");
        }
        String path = "/references/airlines/{airlineCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{airlineCode\\}", this.apiClient.escapeString(airlineCode.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<AirlinesResponse> returnType = new GenericType<AirlinesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AirportsResponse referencesAirportsGet(String lang, String lHoperated) throws ApiException {
        Object postBody = null;
        if (lang == null) {
            throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesAirportsGet");
        }
        String path = "/references/airports/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "lang", lang));
        queryParams.addAll(this.apiClient.parameterToPairs("", "LHoperated", lHoperated));
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<AirportsResponse> returnType = new GenericType<AirportsResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public NearestAirportsResponse referencesAirportsNearestLatitudelongitudeGet(Double latitude, Double longitude, String lang) throws ApiException {
        Object postBody = null;
        if (latitude == null) {
            throw new ApiException(400, "Missing the required parameter 'latitude' when calling referencesAirportsNearestLatitudelongitudeGet");
        }
        if (longitude == null) {
            throw new ApiException(400, "Missing the required parameter 'longitude' when calling referencesAirportsNearestLatitudelongitudeGet");
        }
        if (lang == null) {
            throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesAirportsNearestLatitudelongitudeGet");
        }
        String path = "/references/airports/nearest/{latitude},{longitude}".replaceAll("\\{format\\}", "json").replaceAll("\\{latitude\\}", this.apiClient.escapeString(latitude.toString())).replaceAll("\\{longitude\\}", this.apiClient.escapeString(longitude.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "lang", lang));
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<NearestAirportsResponse> returnType = new GenericType<NearestAirportsResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AirportsResponse referencesAirportsAirportCodeGet(String airportCode, String lang, String lHoperated) throws ApiException {
        Object postBody = null;
        if (airportCode == null) {
            throw new ApiException(400, "Missing the required parameter 'airportCode' when calling referencesAirportsAirportCodeGet");
        }
        if (lang == null) {
            throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesAirportsAirportCodeGet");
        }
        String path = "/references/airports/{airportCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{airportCode\\}", this.apiClient.escapeString(airportCode.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "lang", lang));
        queryParams.addAll(this.apiClient.parameterToPairs("", "LHoperated", lHoperated));
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<AirportsResponse> returnType = new GenericType<AirportsResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CitiesResponse referencesCitiesGet(String lang) throws ApiException {
        Object postBody = null;
        if (lang == null) {
            throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCitiesGet");
        }
        String path = "/references/cities/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "lang", lang));
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<CitiesResponse> returnType = new GenericType<CitiesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CitiesResponse referencesCitiesCityCodeGet(String cityCode, String lang) throws ApiException {
        Object postBody = null;
        if (cityCode == null) {
            throw new ApiException(400, "Missing the required parameter 'cityCode' when calling referencesCitiesCityCodeGet");
        }
        if (lang == null) {
            throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCitiesCityCodeGet");
        }
        String path = "/references/cities/{cityCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{cityCode\\}", this.apiClient.escapeString(cityCode.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "lang", lang));
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<CitiesResponse> returnType = new GenericType<CitiesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CountriesResponse referencesCountriesGet(String lang) throws ApiException {
        Object postBody = null;
        if (lang == null) {
            throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCountriesGet");
        }
        String path = "/references/countries/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "lang", lang));
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<CountriesResponse> returnType = new GenericType<CountriesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CountriesResponse referencesCountriesCountryCodeGet(String countryCode, String lang) throws ApiException {
        Object postBody = null;
        if (countryCode == null) {
            throw new ApiException(400, "Missing the required parameter 'countryCode' when calling referencesCountriesCountryCodeGet");
        }
        if (lang == null) {
            throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCountriesCountryCodeGet");
        }
        String path = "/references/countries/{countryCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "lang", lang));
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKey"};
        GenericType<CountriesResponse> returnType = new GenericType<CountriesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}

