/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.lhapi.client;

import org.apache.commons.lang3.Validate;
import org.hisrc.lhapi.client.LhApiClient;
import org.hisrc.lhapi.client.api.DefaultApi;
import org.hisrc.lhapi.client.invoker.ApiClient;
import org.hisrc.lhapi.client.invoker.ApiException;
import org.hisrc.lhapi.client.invoker.CustomizedApiClient;
import org.hisrc.lhapi.client.model.AccessToken;
import org.hisrc.lhapi.client.model.AircraftSummariesResponse;
import org.hisrc.lhapi.client.model.AirlinesResponse;
import org.hisrc.lhapi.client.model.AirportsResponse;
import org.hisrc.lhapi.client.model.CitiesResponse;
import org.hisrc.lhapi.client.model.CountriesResponse;
import org.hisrc.lhapi.client.model.FlightStatusResponse;
import org.hisrc.lhapi.client.model.FlightsStatusResponse;
import org.hisrc.lhapi.client.model.NearestAirportsResponse;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AuthenticatingLhApiClient
implements LhApiClient {
    private static final int EXPIRATION_BUFFER = 900000;
    private static final String GRANT_TYPE = "client_credentials";
    private static final String API_KEY_PREFIX_BEARER = "Bearer";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm");
    private final ApiClient apiClient = new CustomizedApiClient();
    private final DefaultApi api = new DefaultApi(this.apiClient);
    private final String clientId;
    private final String clientSecret;
    private long accessTokenExpirationTimestamp = Long.MIN_VALUE;

    public AuthenticatingLhApiClient(String clientId, String clientSecret) {
        Validate.notNull((Object)clientId);
        Validate.notNull((Object)clientSecret);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    private void refreshAccessToken() throws ApiException {
        long currentTimestamp = System.currentTimeMillis();
        AccessToken accessToken = this.api.oauthTokenPost(this.clientId, this.clientSecret, GRANT_TYPE);
        if (accessToken == null) {
            throw new ApiException("Authentication returned null access token.");
        }
        String token = accessToken.getAccessToken();
        if (token == null) {
            throw new ApiException("Authentication returned null token.");
        }
        Integer expiresIn = accessToken.getExpiresIn();
        if (expiresIn == null) {
            throw new ApiException("Authentication returned null expiration date.");
        }
        this.apiClient.setApiKey("Bearer " + token);
        this.accessTokenExpirationTimestamp = currentTimestamp + (long)(expiresIn * 1000) - 900000L;
    }

    @Override
    public CountriesResponse countries(String countryCode, String lang) throws ApiException {
        String _lang;
        String string = _lang = lang == null ? "EN" : lang;
        if (countryCode == null) {
            return this.executeAuthentified(() -> this.referencesCountriesGet(_lang));
        }
        return this.executeAuthentified(() -> this.referencesCountriesCountryCodeGet(countryCode, _lang));
    }

    @Override
    public CitiesResponse cities(String cityCode, String lang) throws ApiException {
        String _lang;
        String string = _lang = lang == null ? "EN" : lang;
        if (cityCode == null) {
            return this.executeAuthentified(() -> this.referencesCitiesGet(_lang));
        }
        return this.executeAuthentified(() -> this.referencesCitiesCityCodeGet(cityCode, _lang));
    }

    @Override
    public AirportsResponse airports(String airportCode, String lang, Boolean lhOperates) throws ApiException {
        String _lang;
        String string = _lang = lang == null ? "EN" : lang;
        if (airportCode == null) {
            return this.executeAuthentified(() -> this.referencesAirportsGet(_lang, lhOperates));
        }
        return this.executeAuthentified(() -> this.referencesAirportsAirportCodeGet(airportCode, _lang, lhOperates));
    }

    @Override
    public NearestAirportsResponse nearestAirports(Double latitude, Double longitude, String lang) throws ApiException {
        String _lang = lang == null ? "EN" : lang;
        return this.executeAuthentified(() -> this.referencesAirportsNearestLatitudelongitudeGet(latitude, longitude, _lang));
    }

    @Override
    public AirlinesResponse airlines(String airlineCode) throws ApiException {
        if (airlineCode == null) {
            return this.executeAuthentified(() -> this.referencesAirlinesGet());
        }
        return this.executeAuthentified(() -> this.referencesAirlinesAirlineCodeGet(airlineCode));
    }

    @Override
    public AircraftSummariesResponse aircraftSummaries(String aircraftCode) throws ApiException {
        if (aircraftCode == null) {
            return this.executeAuthentified(() -> this.referencesAircraftGet());
        }
        return this.executeAuthentified(() -> this.referencesAircraftAircraftCodeGet(aircraftCode));
    }

    @Override
    public FlightStatusResponse flightStatus(String flightNumber, LocalDate date) throws ApiException {
        return this.executeAuthentified(() -> this.operationsFlightstatusFlightNumberDateGet(flightNumber, date));
    }

    @Override
    public FlightsStatusResponse arrivalsStatus(String airportCode, LocalDateTime from, LocalDateTime until) throws ApiException {
        return this.executeAuthentified(() -> this.operationsFlightstatusArrivalsAirportCodeFromUntilGet(airportCode, from, until));
    }

    @Override
    public FlightsStatusResponse departuresStatus(String airportCode, LocalDateTime from, LocalDateTime until) throws ApiException {
        return this.executeAuthentified(() -> this.operationsFlightstatusDeparturesAirportCodeFromUntilGet(airportCode, from, until));
    }

    private <T> T executeAuthentified(ApiOperation<T> operation) throws ApiException {
        long currentTimestamp = System.currentTimeMillis();
        if (this.accessTokenExpirationTimestamp < currentTimestamp) {
            this.refreshAccessToken();
        }
        try {
            return operation.execute();
        }
        catch (ApiException apiex) {
            this.refreshAccessToken();
            return operation.execute();
        }
    }

    private CountriesResponse referencesCountriesGet(String lang) throws ApiException {
        return this.api.referencesCountriesGet(lang);
    }

    private CountriesResponse referencesCountriesCountryCodeGet(String countryCode, String lang) throws ApiException {
        return this.api.referencesCountriesCountryCodeGet(countryCode, lang);
    }

    private CitiesResponse referencesCitiesGet(String lang) throws ApiException {
        return this.api.referencesCitiesGet(lang);
    }

    private CitiesResponse referencesCitiesCityCodeGet(String cityCode, String lang) throws ApiException {
        return this.api.referencesCitiesCityCodeGet(cityCode, lang);
    }

    private AirportsResponse referencesAirportsGet(String lang, Boolean lhOperated) throws ApiException {
        return this.api.referencesAirportsGet(lang, lhOperated == null ? null : lhOperated.toString());
    }

    private AirportsResponse referencesAirportsAirportCodeGet(String airportCode, String lang, Boolean lhOperated) throws ApiException {
        return this.api.referencesAirportsAirportCodeGet(airportCode, lang, lhOperated == null ? null : lhOperated.toString());
    }

    private NearestAirportsResponse referencesAirportsNearestLatitudelongitudeGet(Double latitude, Double longitude, String lang) throws ApiException {
        return this.api.referencesAirportsNearestLatitudelongitudeGet(latitude, longitude, lang);
    }

    private AirlinesResponse referencesAirlinesGet() throws ApiException {
        return this.api.referencesAirlinesGet();
    }

    private AirlinesResponse referencesAirlinesAirlineCodeGet(String airlineCode) throws ApiException {
        return this.api.referencesAirlinesAirlineCodeGet(airlineCode);
    }

    private AircraftSummariesResponse referencesAircraftGet() throws ApiException {
        return this.api.referencesAircraftGet();
    }

    private AircraftSummariesResponse referencesAircraftAircraftCodeGet(String aircraftCode) throws ApiException {
        return this.api.referencesAircraftAircraftCodeGet(aircraftCode);
    }

    private FlightStatusResponse operationsFlightstatusFlightNumberDateGet(String flightNumber, LocalDate date) throws ApiException {
        String dateAsString = DATE_FORMATTER.print((ReadablePartial)date);
        return this.api.operationsFlightstatusFlightNumberDateGet(flightNumber, dateAsString);
    }

    private FlightsStatusResponse operationsFlightstatusArrivalsAirportCodeFromUntilGet(String airportCode, LocalDateTime from, LocalDateTime until) throws ApiException {
        String fromAsString = DATE_TIME_FORMATTER.print((ReadablePartial)from);
        String untilAsString = DATE_TIME_FORMATTER.print((ReadablePartial)until);
        return this.api.operationsFlightstatusArrivalsAirportCodeFromUntilGet(airportCode, fromAsString, untilAsString);
    }

    private FlightsStatusResponse operationsFlightstatusDeparturesAirportCodeFromUntilGet(String airportCode, LocalDateTime from, LocalDateTime until) throws ApiException {
        String fromAsString = DATE_TIME_FORMATTER.print((ReadablePartial)from);
        String untilAsString = DATE_TIME_FORMATTER.print((ReadablePartial)until);
        return this.api.operationsFlightstatusDeparturesAirportCodeFromUntilGet(airportCode, fromAsString, untilAsString);
    }

    @FunctionalInterface
    private static interface ApiOperation<T> {
        public T execute() throws ApiException;
    }
}

