package org.hisrc.lhapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hisrc.lhapi.client.model.Distance;
import org.hisrc.lhapi.client.model.Names;
import org.hisrc.lhapi.client.model.Position;







@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-02-16T10:45:00.864+01:00")
public class Airport   {
  
  private String airportCode = null;
  private String cityCode = null;
  private String countryCode = null;
  private Position position = null;


  public enum LocationTypeEnum {
    AIRPORT("Airport"),
    RAILWAYSTATION("RailwayStation"),
    BUSSTATION("BusStation");

    private String value;

    LocationTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return value;
    }
  }

  private LocationTypeEnum locationType = null;
  private Names names = null;
  private Distance distance = null;

  
  /**
   **/
  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("AirportCode")
  public String getAirportCode() {
    return airportCode;
  }
  public void setAirportCode(String airportCode) {
    this.airportCode = airportCode;
  }

  
  /**
   **/
  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("CityCode")
  public String getCityCode() {
    return cityCode;
  }
  public void setCityCode(String cityCode) {
    this.cityCode = cityCode;
  }

  
  /**
   **/
  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("CountryCode")
  public String getCountryCode() {
    return countryCode;
  }
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }

  
  /**
   **/
  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("Position")
  public Position getPosition() {
    return position;
  }
  public void setPosition(Position position) {
    this.position = position;
  }

  
  /**
   **/
  
  @ApiModelProperty(value = "")
  @JsonProperty("LocationType")
  public LocationTypeEnum getLocationType() {
    return locationType;
  }
  public void setLocationType(LocationTypeEnum locationType) {
    this.locationType = locationType;
  }

  
  /**
   **/
  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("Names")
  public Names getNames() {
    return names;
  }
  public void setNames(Names names) {
    this.names = names;
  }

  
  /**
   **/
  
  @ApiModelProperty(value = "")
  @JsonProperty("Distance")
  public Distance getDistance() {
    return distance;
  }
  public void setDistance(Distance distance) {
    this.distance = distance;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Airport airport = (Airport) o;

    return true && Objects.equals(airportCode, airport.airportCode) &&
        Objects.equals(cityCode, airport.cityCode) &&
        Objects.equals(countryCode, airport.countryCode) &&
        Objects.equals(position, airport.position) &&
        Objects.equals(locationType, airport.locationType) &&
        Objects.equals(names, airport.names) &&
        Objects.equals(distance, airport.distance)
    ;
  }

  @Override
  public int hashCode() {
    return Objects.hash(airportCode, cityCode, countryCode, position, locationType, names, distance);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Airport {\n");
    
    sb.append("    airportCode: ").append(toIndentedString(airportCode)).append("\n");
    sb.append("    cityCode: ").append(toIndentedString(cityCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    locationType: ").append(toIndentedString(locationType)).append("\n");
    sb.append("    names: ").append(toIndentedString(names)).append("\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}



