package org.hisrc.lhapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;







@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-02-16T10:45:00.864+01:00")
public class AccessToken   {
  
  private String accessToken = null;


  public enum TokenTypeEnum {
    BEARER("bearer");

    private String value;

    TokenTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return value;
    }
  }

  private TokenTypeEnum tokenType = null;
  private Integer expiresIn = null;

  
  /**
   * Your new access token
   **/
  
  @ApiModelProperty(required = true, value = "Your new access token")
  @JsonProperty("access_token")
  public String getAccessToken() {
    return accessToken;
  }
  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }

  
  /**
   * Type of the token. We only use bearer tokens. Note that we respond with token_type \"bearer\" (lower case b) yet when you send us a token it must be named \"Bearer\" (upper case B).
   **/
  
  @ApiModelProperty(required = true, value = "Type of the token. We only use bearer tokens. Note that we respond with token_type \"bearer\" (lower case b) yet when you send us a token it must be named \"Bearer\" (upper case B).")
  @JsonProperty("token_type")
  public TokenTypeEnum getTokenType() {
    return tokenType;
  }
  public void setTokenType(TokenTypeEnum tokenType) {
    this.tokenType = tokenType;
  }

  
  /**
   * The number of seconds until this token expires
   **/
  
  @ApiModelProperty(required = true, value = "The number of seconds until this token expires")
  @JsonProperty("expires_in")
  public Integer getExpiresIn() {
    return expiresIn;
  }
  public void setExpiresIn(Integer expiresIn) {
    this.expiresIn = expiresIn;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccessToken accessToken = (AccessToken) o;

    return true && Objects.equals(accessToken, accessToken.accessToken) &&
        Objects.equals(tokenType, accessToken.tokenType) &&
        Objects.equals(expiresIn, accessToken.expiresIn)
    ;
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessToken, tokenType, expiresIn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccessToken {\n");
    
    sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
    sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
    sb.append("    expiresIn: ").append(toIndentedString(expiresIn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}



