package org.hisrc.lhapi.client.api;

import com.sun.jersey.api.client.GenericType;

import org.hisrc.lhapi.client.invoker.ApiException;
import org.hisrc.lhapi.client.invoker.ApiClient;
import org.hisrc.lhapi.client.invoker.Configuration;
import org.hisrc.lhapi.client.invoker.Pair;

import org.hisrc.lhapi.client.model.AccessToken;
import org.hisrc.lhapi.client.model.FlightsStatusResponse;
import org.hisrc.lhapi.client.model.FlightStatusResponse;
import org.hisrc.lhapi.client.model.AircraftSummariesResponse;
import org.hisrc.lhapi.client.model.AirlinesResponse;
import org.hisrc.lhapi.client.model.AirportsResponse;
import org.hisrc.lhapi.client.model.NearestAirportsResponse;
import org.hisrc.lhapi.client.model.CitiesResponse;
import org.hisrc.lhapi.client.model.CountriesResponse;



import java.util.*;


@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-02-16T10:45:00.864+01:00")

public class DefaultApi {
  private ApiClient apiClient;

  public DefaultApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DefaultApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  
  /**
   * 
   * Access to our services is controlled via tokens (Oauth 2.0). To get a token you must call our token end-point and supply your client key and client secret. Tokens remain valid for a limited time.
   * @param clientId Your client application key
   * @param clientSecret Your client secret
   * @param grantType Grant type, must be \&quot;client_credentials\&quot;
   * @return AccessToken
   */
  public AccessToken oauthTokenPost(String clientId, String clientSecret, String grantType) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'clientId' is set
     if (clientId == null) {
        throw new ApiException(400, "Missing the required parameter 'clientId' when calling oauthTokenPost");
     }
     
     // verify the required parameter 'clientSecret' is set
     if (clientSecret == null) {
        throw new ApiException(400, "Missing the required parameter 'clientSecret' when calling oauthTokenPost");
     }
     
     // verify the required parameter 'grantType' is set
     if (grantType == null) {
        throw new ApiException(400, "Missing the required parameter 'grantType' when calling oauthTokenPost");
     }
     
    // create path and map variables
    String path = "/oauth/token".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    if (clientId != null)
      formParams.put("client_id", clientId);
    if (clientSecret != null)
      formParams.put("client_secret", clientSecret);
    if (grantType != null)
      formParams.put("grant_type", grantType);
    

    final String[] accepts = {
      
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/x-www-form-urlencoded"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] {  };

    
    GenericType<AccessToken> returnType = new GenericType<AccessToken>() {};
    return apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * The status of all arrivals at a given airport within a specific time range
   * @param airportCode The IATA code of the arrival airport (e.g. ZRH)
   * @param from Start of time range in local time of arrival airport (e.g. 2014-11-18T10:30)
   * @param until End of time range in local time of arrival airport (e.g. 2014-11-18T12:30)
   * @return FlightsStatusResponse
   */
  public FlightsStatusResponse operationsFlightstatusArrivalsAirportCodeFromUntilGet(String airportCode, String from, String until) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'airportCode' is set
     if (airportCode == null) {
        throw new ApiException(400, "Missing the required parameter 'airportCode' when calling operationsFlightstatusArrivalsAirportCodeFromUntilGet");
     }
     
     // verify the required parameter 'from' is set
     if (from == null) {
        throw new ApiException(400, "Missing the required parameter 'from' when calling operationsFlightstatusArrivalsAirportCodeFromUntilGet");
     }
     
     // verify the required parameter 'until' is set
     if (until == null) {
        throw new ApiException(400, "Missing the required parameter 'until' when calling operationsFlightstatusArrivalsAirportCodeFromUntilGet");
     }
     
    // create path and map variables
    String path = "/operations/flightstatus/arrivals/{airportCode}/{from}/{until}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "airportCode" + "\\}", apiClient.escapeString(airportCode.toString()))
      .replaceAll("\\{" + "from" + "\\}", apiClient.escapeString(from.toString()))
      .replaceAll("\\{" + "until" + "\\}", apiClient.escapeString(until.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<FlightsStatusResponse> returnType = new GenericType<FlightsStatusResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * The status of all departures from a given airport within a specific time range
   * @param airportCode The IATA code of the departure airport (e.g. HAM)
   * @param from Start of time range in local time of departure airport (e.g. 2014-11-18T10:30)
   * @param until End of time range in local time of departure airport (e.g. 2014-11-18T12:30)
   * @return FlightsStatusResponse
   */
  public FlightsStatusResponse operationsFlightstatusDeparturesAirportCodeFromUntilGet(String airportCode, String from, String until) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'airportCode' is set
     if (airportCode == null) {
        throw new ApiException(400, "Missing the required parameter 'airportCode' when calling operationsFlightstatusDeparturesAirportCodeFromUntilGet");
     }
     
     // verify the required parameter 'from' is set
     if (from == null) {
        throw new ApiException(400, "Missing the required parameter 'from' when calling operationsFlightstatusDeparturesAirportCodeFromUntilGet");
     }
     
     // verify the required parameter 'until' is set
     if (until == null) {
        throw new ApiException(400, "Missing the required parameter 'until' when calling operationsFlightstatusDeparturesAirportCodeFromUntilGet");
     }
     
    // create path and map variables
    String path = "/operations/flightstatus/departures/{airportCode}/{from}/{until}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "airportCode" + "\\}", apiClient.escapeString(airportCode.toString()))
      .replaceAll("\\{" + "from" + "\\}", apiClient.escapeString(from.toString()))
      .replaceAll("\\{" + "until" + "\\}", apiClient.escapeString(until.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<FlightsStatusResponse> returnType = new GenericType<FlightsStatusResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Get the status of a particular flight (on time, landed, etc.)
   * @param flightNumber The flight number including carrier code and any suffix, e.g. LH400
   * @param date The departure date (YYYY-MM-DD) in the local time of the departure airport.
   * @return FlightStatusResponse
   */
  public FlightStatusResponse operationsFlightstatusFlightNumberDateGet(String flightNumber, String date) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'flightNumber' is set
     if (flightNumber == null) {
        throw new ApiException(400, "Missing the required parameter 'flightNumber' when calling operationsFlightstatusFlightNumberDateGet");
     }
     
     // verify the required parameter 'date' is set
     if (date == null) {
        throw new ApiException(400, "Missing the required parameter 'date' when calling operationsFlightstatusFlightNumberDateGet");
     }
     
    // create path and map variables
    String path = "/operations/flightstatus/{flightNumber}/{date}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "flightNumber" + "\\}", apiClient.escapeString(flightNumber.toString()))
      .replaceAll("\\{" + "date" + "\\}", apiClient.escapeString(date.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<FlightStatusResponse> returnType = new GenericType<FlightStatusResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Reference data about aircraft. With no parameters, all aircraft types are returned.
   * @return AircraftSummariesResponse
   */
  public AircraftSummariesResponse referencesAircraftGet() throws ApiException {
    Object postBody = null;
    
    // create path and map variables
    String path = "/references/aircraft/".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<AircraftSummariesResponse> returnType = new GenericType<AircraftSummariesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Reference data about aircraft. With no parameters, all aircraft types are returned.
   * @param aircraftCode Optional 3-character IATA aircraft code.
   * @return AircraftSummariesResponse
   */
  public AircraftSummariesResponse referencesAircraftAircraftCodeGet(String aircraftCode) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'aircraftCode' is set
     if (aircraftCode == null) {
        throw new ApiException(400, "Missing the required parameter 'aircraftCode' when calling referencesAircraftAircraftCodeGet");
     }
     
    // create path and map variables
    String path = "/references/aircraft/{aircraftCode}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "aircraftCode" + "\\}", apiClient.escapeString(aircraftCode.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<AircraftSummariesResponse> returnType = new GenericType<AircraftSummariesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Reference data about airlines. With no parameters, all airlines are returned.
   * @return AirlinesResponse
   */
  public AirlinesResponse referencesAirlinesGet() throws ApiException {
    Object postBody = null;
    
    // create path and map variables
    String path = "/references/airlines/".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<AirlinesResponse> returnType = new GenericType<AirlinesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Reference data about airlines. With no parameters, all airlines are returned.
   * @param airlineCode Optional 2-character IATA airline/carrier code
   * @return AirlinesResponse
   */
  public AirlinesResponse referencesAirlinesAirlineCodeGet(String airlineCode) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'airlineCode' is set
     if (airlineCode == null) {
        throw new ApiException(400, "Missing the required parameter 'airlineCode' when calling referencesAirlinesAirlineCodeGet");
     }
     
    // create path and map variables
    String path = "/references/airlines/{airlineCode}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "airlineCode" + "\\}", apiClient.escapeString(airlineCode.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<AirlinesResponse> returnType = new GenericType<AirlinesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Reference data about airports. With no parameters, all airports are returned in all languages. This is a large data set. If an airport code is specified there is the option to recieve the description in a single language.
   * @param lang Optional query parameter. 2 letter ISO 3166-1 language code.
   * @param lHoperated Optional query parameter. Restrict the results to locations with flights operated by LH (true, false).
   * @return AirportsResponse
   */
  public AirportsResponse referencesAirportsGet(String lang, String lHoperated) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'lang' is set
     if (lang == null) {
        throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesAirportsGet");
     }
     
    // create path and map variables
    String path = "/references/airports/".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    
    queryParams.addAll(apiClient.parameterToPairs("", "lang", lang));
    
    queryParams.addAll(apiClient.parameterToPairs("", "LHoperated", lHoperated));
    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<AirportsResponse> returnType = new GenericType<AirportsResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Find the 5 closest airports to the given latitude and longitude, irrespective of the radius of the reference point.
   * @param latitude Latitude in decimal format to at most 3 decimal places
   * @param longitude Longitude in decimal format to at most 3 decimal places
   * @param lang Optional query parameter. 2 letter ISO 3166-1 language code.
   * @return NearestAirportsResponse
   */
  public NearestAirportsResponse referencesAirportsNearestLatitudelongitudeGet(Double latitude, Double longitude, String lang) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'latitude' is set
     if (latitude == null) {
        throw new ApiException(400, "Missing the required parameter 'latitude' when calling referencesAirportsNearestLatitudelongitudeGet");
     }
     
     // verify the required parameter 'longitude' is set
     if (longitude == null) {
        throw new ApiException(400, "Missing the required parameter 'longitude' when calling referencesAirportsNearestLatitudelongitudeGet");
     }
     
     // verify the required parameter 'lang' is set
     if (lang == null) {
        throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesAirportsNearestLatitudelongitudeGet");
     }
     
    // create path and map variables
    String path = "/references/airports/nearest/{latitude},{longitude}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "latitude" + "\\}", apiClient.escapeString(latitude.toString()))
      .replaceAll("\\{" + "longitude" + "\\}", apiClient.escapeString(longitude.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    
    queryParams.addAll(apiClient.parameterToPairs("", "lang", lang));
    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<NearestAirportsResponse> returnType = new GenericType<NearestAirportsResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Reference data about airports. With no parameters, all airports are returned in all languages. This is a large data set. If an airport code is specified there is the option to recieve the description in a single language.
   * @param airportCode Optional 3 letter IATA airport code
   * @param lang Optional query parameter. 2 letter ISO 3166-1 language code.
   * @param lHoperated Optional query parameter. Restrict the results to locations with flights operated by LH (true, false).
   * @return AirportsResponse
   */
  public AirportsResponse referencesAirportsAirportCodeGet(String airportCode, String lang, String lHoperated) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'airportCode' is set
     if (airportCode == null) {
        throw new ApiException(400, "Missing the required parameter 'airportCode' when calling referencesAirportsAirportCodeGet");
     }
     
     // verify the required parameter 'lang' is set
     if (lang == null) {
        throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesAirportsAirportCodeGet");
     }
     
    // create path and map variables
    String path = "/references/airports/{airportCode}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "airportCode" + "\\}", apiClient.escapeString(airportCode.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    
    queryParams.addAll(apiClient.parameterToPairs("", "lang", lang));
    
    queryParams.addAll(apiClient.parameterToPairs("", "LHoperated", lHoperated));
    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<AirportsResponse> returnType = new GenericType<AirportsResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Retreive a list of all city or details of one specific city. If a city is specified, there is an option to limit the response to a given language.
   * @param lang Optional query parameter. 2 letter ISO 3166-1 language code.
   * @return CitiesResponse
   */
  public CitiesResponse referencesCitiesGet(String lang) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'lang' is set
     if (lang == null) {
        throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCitiesGet");
     }
     
    // create path and map variables
    String path = "/references/cities/".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    
    queryParams.addAll(apiClient.parameterToPairs("", "lang", lang));
    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<CitiesResponse> returnType = new GenericType<CitiesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Retreive a list of all city or details of one specific city. If a city is specified, there is an option to limit the response to a given language.
   * @param cityCode Optional 3 letter IATA city code
   * @param lang Optional query parameter. 2 letter ISO 3166-1 language code.
   * @return CitiesResponse
   */
  public CitiesResponse referencesCitiesCityCodeGet(String cityCode, String lang) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'cityCode' is set
     if (cityCode == null) {
        throw new ApiException(400, "Missing the required parameter 'cityCode' when calling referencesCitiesCityCodeGet");
     }
     
     // verify the required parameter 'lang' is set
     if (lang == null) {
        throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCitiesCityCodeGet");
     }
     
    // create path and map variables
    String path = "/references/cities/{cityCode}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "cityCode" + "\\}", apiClient.escapeString(cityCode.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    
    queryParams.addAll(apiClient.parameterToPairs("", "lang", lang));
    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<CitiesResponse> returnType = new GenericType<CitiesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Retreive a list of all countries or details of one specific country. If a country is specified, there is an option to limit the response to a given language.
   * @param lang Optional query parameter. 2 letter ISO 3166-1 language code.
   * @return CountriesResponse
   */
  public CountriesResponse referencesCountriesGet(String lang) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'lang' is set
     if (lang == null) {
        throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCountriesGet");
     }
     
    // create path and map variables
    String path = "/references/countries/".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    
    queryParams.addAll(apiClient.parameterToPairs("", "lang", lang));
    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<CountriesResponse> returnType = new GenericType<CountriesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
  /**
   * 
   * Retreive a list of all countries or details of one specific country. If a country is specified, there is an option to limit the response to a given language.
   * @param countryCode Optional 2 letter ISO 3166-1 country code.
   * @param lang Optional query parameter. 2 letter ISO 3166-1 language code.
   * @return CountriesResponse
   */
  public CountriesResponse referencesCountriesCountryCodeGet(String countryCode, String lang) throws ApiException {
    Object postBody = null;
    
     // verify the required parameter 'countryCode' is set
     if (countryCode == null) {
        throw new ApiException(400, "Missing the required parameter 'countryCode' when calling referencesCountriesCountryCodeGet");
     }
     
     // verify the required parameter 'lang' is set
     if (lang == null) {
        throw new ApiException(400, "Missing the required parameter 'lang' when calling referencesCountriesCountryCodeGet");
     }
     
    // create path and map variables
    String path = "/references/countries/{countryCode}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "countryCode" + "\\}", apiClient.escapeString(countryCode.toString()));

    // query params
    List<Pair> queryParams = new ArrayList<Pair>();
    Map<String, String> headerParams = new HashMap<String, String>();
    Map<String, Object> formParams = new HashMap<String, Object>();

    
    queryParams.addAll(apiClient.parameterToPairs("", "lang", lang));
    

    

    

    final String[] accepts = {
      "application/json"
    };
    final String accept = apiClient.selectHeaderAccept(accepts);

    final String[] contentTypes = {
      "application/json"
    };
    final String contentType = apiClient.selectHeaderContentType(contentTypes);

    String[] authNames = new String[] { "apiKey" };

    
    GenericType<CountriesResponse> returnType = new GenericType<CountriesResponse>() {};
    return apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    
  }
  
}

