/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.spring.scan;

import java.lang.reflect.Method;
import org.hellojavaer.ddal.ddr.cluster.DBClusterRouteContext;
import org.hellojavaer.ddal.ddr.expression.el.spel.DDRSpelEvaluationContext;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

class MethodBasedSpelExpression {
    private static volatile boolean notSupportParameterNameDiscoverer = false;
    private String[] parameterNames;
    private Expression expression;

    public MethodBasedSpelExpression(String el, Method method) {
        el = DDRStringUtils.trimToNull((String)el);
        if (el != null) {
            SpelExpressionParser parser = new SpelExpressionParser();
            this.expression = parser.parseExpression(el, DDRSpelEvaluationContext.PARSER_CONTEXT);
            this.parameterNames = this.getParameterNames(method);
        }
    }

    public <T> T parse(Class<T> type, Object ... args) {
        if (this.expression == null) {
            return null;
        }
        EvaluationContext context = this.buildEvaluationContext();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (this.parameterNames != null && this.parameterNames.length > i) {
                    context.setVariable(this.parameterNames[i], args[i]);
                }
                context.setVariable("$" + i, args[i]);
            }
        }
        return (T)this.expression.getValue(context, type);
    }

    private String[] getParameterNames(Method method) {
        if (notSupportParameterNameDiscoverer) {
            return null;
        }
        try {
            DefaultParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
            String[] strs = parameterNameDiscoverer.getParameterNames(method);
            if (strs == null) {
                notSupportParameterNameDiscoverer = true;
            }
            return strs;
        }
        catch (NoClassDefFoundError e) {
            notSupportParameterNameDiscoverer = true;
            return null;
        }
    }

    private EvaluationContext buildEvaluationContext() {
        return new DDRSpelEvaluationContext(){

            public Object lookupVariable(String name) {
                Object obj = null;
                try {
                    obj = super.lookupVariable(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (obj == null) {
                    obj = DBClusterRouteContext.lookupVariable((String)name);
                }
                return obj;
            }
        };
    }
}

