/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.spring.scan;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.hellojavaer.ddal.ddr.shard.ShardRoute;
import org.hellojavaer.ddal.ddr.shard.ShardRouteContext;
import org.hellojavaer.ddal.spring.scan.MethodBasedSpelExpression;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EnableShardRouteAnnotation {
    private Map<Method, MethodBasedSpelExpression> expressionCache = new HashMap<Method, MethodBasedSpelExpression>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(shardRoute)")
    public Object around(ProceedingJoinPoint joinPoint, ShardRoute shardRoute) throws Throwable {
        try {
            ShardRouteContext.pushContext();
            if (shardRoute.scName() != null && shardRoute.scName().length() > 0 && shardRoute.sdValue() != null && shardRoute.sdValue().length() > 0) {
                String[] scNames;
                MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                Method method = methodSignature.getMethod();
                MethodBasedSpelExpression expression = this.expressionCache.get(method);
                Object[] args = joinPoint.getArgs();
                if (expression == null) {
                    Map<Method, MethodBasedSpelExpression> map = this.expressionCache;
                    synchronized (map) {
                        expression = this.expressionCache.get(method);
                        if (expression == null) {
                            expression = new MethodBasedSpelExpression(shardRoute.sdValue(), method);
                            this.expressionCache.put(method, expression);
                        }
                    }
                }
                Object val = expression.parse(Object.class, args);
                for (String scName : scNames = shardRoute.scName().split(",")) {
                    ShardRouteContext.setRouteInfo((String)scName, (Object)val);
                }
            } else if (shardRoute.scName() != null && shardRoute.scName().length() != 0 || shardRoute.sdValue() != null && shardRoute.sdValue().length() != 0) {
                throw new IllegalArgumentException("scName and sdValue should either both have a non-empty value or both have a empty value");
            }
            Object object = joinPoint.proceed(joinPoint.getArgs());
            return object;
        }
        finally {
            ShardRouteContext.popContext();
        }
    }
}

