/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.spring.scan;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.hellojavaer.ddal.ddr.cluster.DBClusterRoute;
import org.hellojavaer.ddal.ddr.cluster.DBClusterRouteContext;
import org.hellojavaer.ddal.spring.scan.MethodBasedSpelExpression;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EnableDBClusterRouteAnnotation {
    private Map<Method, MethodBasedSpelExpression> expressionCache = new HashMap<Method, MethodBasedSpelExpression>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(dbClusterRoute)")
    public Object around(ProceedingJoinPoint joinPoint, DBClusterRoute dbClusterRoute) throws Throwable {
        try {
            DBClusterRouteContext.pushContext();
            Object[] args = joinPoint.getArgs();
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            MethodBasedSpelExpression expression = this.expressionCache.get(method);
            if (expression == null) {
                Map<Method, MethodBasedSpelExpression> map = this.expressionCache;
                synchronized (map) {
                    expression = this.expressionCache.get(method);
                    if (expression == null) {
                        expression = new MethodBasedSpelExpression(dbClusterRoute.clusterName(), method);
                        this.expressionCache.put(method, expression);
                    }
                }
            }
            String targetClusterName = expression.parse(String.class, args);
            DBClusterRouteContext.setClusterName((String)targetClusterName);
            Object object = joinPoint.proceed(args);
            return object;
        }
        finally {
            DBClusterRouteContext.popContext();
        }
    }
}

