/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.spring.scan;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.hellojavaer.ddal.ddr.shard.ShardRoute;
import org.hellojavaer.ddal.ddr.shard.ShardRouteContext;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EnableShardRouteAnnotation {
    private ParameterNameDiscoverer parameterNameDiscoverer = null;
    private static boolean notSupportParameterNameDiscoverer = false;
    private Map<Method, InnerBean> expressionCache = new HashMap<Method, InnerBean>();
    private static final TypedValue rootObject = new TypedValue(null);
    private static final List<PropertyAccessor> propertyAccessors = new ArrayList<PropertyAccessor>(1);
    private static final ParserContext PARSER_CONTEXT = new ParserContext(){

        public boolean isTemplate() {
            return true;
        }

        public String getExpressionPrefix() {
            return "{";
        }

        public String getExpressionSuffix() {
            return "}";
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(shardRoute)")
    public Object around(ProceedingJoinPoint joinPoint, ShardRoute shardRoute) throws Throwable {
        try {
            ShardRouteContext.pushContext();
            if (shardRoute.scName() != null && shardRoute.scName().length() > 0 && shardRoute.sdValue() != null && shardRoute.sdValue().length() > 0) {
                String[] scNames;
                MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                Method method = methodSignature.getMethod();
                InnerBean innerBean = this.expressionCache.get(method);
                Object[] args = joinPoint.getArgs();
                Object val = null;
                if (innerBean == null) {
                    EnableShardRouteAnnotation enableShardRouteAnnotation = this;
                    synchronized (enableShardRouteAnnotation) {
                        innerBean = this.expressionCache.get(method);
                        if (innerBean == null) {
                            SpelExpressionParser parser = new SpelExpressionParser();
                            Expression expression0 = null;
                            String sdValue = shardRoute.sdValue();
                            if ((sdValue = DDRStringUtils.trimToNull((String)sdValue)) != null) {
                                expression0 = parser.parseExpression(sdValue, PARSER_CONTEXT);
                            }
                            String[] paramNames = this.getParameterNames(method);
                            val = this.calculate(expression0, paramNames, args);
                            InnerBean innerBean1 = new InnerBean(paramNames, expression0);
                            innerBean1.getExpression();
                            this.expressionCache.put(method, innerBean1);
                        } else {
                            val = this.calculate(innerBean.getExpression(), innerBean.getParameterNames(), args);
                        }
                    }
                } else {
                    val = this.calculate(innerBean.getExpression(), innerBean.getParameterNames(), args);
                }
                for (String scName : scNames = shardRoute.scName().split(",")) {
                    ShardRouteContext.setRouteInfo((String)scName, (Object)val);
                }
            } else if (shardRoute.scName() != null && shardRoute.scName().length() != 0 || shardRoute.sdValue() != null && shardRoute.sdValue().length() != 0) {
                throw new IllegalArgumentException("scName and sdValue should either both have a non-empty value or both have a empty value");
            }
            Object object = joinPoint.proceed(joinPoint.getArgs());
            return object;
        }
        finally {
            ShardRouteContext.popContext();
        }
    }

    private String[] getParameterNames(Method method) {
        if (notSupportParameterNameDiscoverer) {
            return null;
        }
        try {
            this.parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
            String[] strs = this.parameterNameDiscoverer.getParameterNames(method);
            if (strs == null) {
                notSupportParameterNameDiscoverer = true;
            }
            return strs;
        }
        catch (NoClassDefFoundError e) {
            notSupportParameterNameDiscoverer = true;
            return null;
        }
    }

    private Object calculate(Expression expression, String[] parameterNames, Object[] args) {
        Object ret;
        if (expression == null) {
            return null;
        }
        EvaluationContext context = EnableShardRouteAnnotation.buildEvaluationContext();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (parameterNames != null && parameterNames.length > i) {
                    context.setVariable(parameterNames[i], args[i]);
                }
                context.setVariable("$" + i, args[i]);
            }
        }
        if ((ret = expression.getValue(context)) == null) {
            return null;
        }
        if (ret instanceof List) {
            if (((List)ret).isEmpty()) {
                return null;
            }
            return ((List)ret).get(0);
        }
        return ret;
    }

    private static EvaluationContext buildEvaluationContext() {
        StandardEvaluationContext context = new StandardEvaluationContext(rootObject){

            public List<PropertyAccessor> getPropertyAccessors() {
                return propertyAccessors;
            }
        };
        return context;
    }

    static {
        propertyAccessors.add((PropertyAccessor)new ReflectivePropertyAccessor());
        propertyAccessors.add(new PropertyAccessor(){

            public Class<?>[] getSpecificTargetClasses() {
                return null;
            }

            public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
                return true;
            }

            public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
                return new TypedValue(context.lookupVariable(name));
            }

            public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
                return false;
            }

            public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
            }
        });
    }

    private class InnerBean {
        private String[] parameterNames;
        private Expression expression;

        public InnerBean(String[] parameterNames, Expression expression) {
            this.parameterNames = parameterNames;
            this.expression = expression;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        public void setParameterNames(String[] parameterNames) {
            this.parameterNames = parameterNames;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }
    }
}

