/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.sequence;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hellojavaer.ddal.core.utils.Assert;
import org.hellojavaer.ddal.sequence.ExceptionHandler;
import org.hellojavaer.ddal.sequence.Sequence;
import org.hellojavaer.ddal.sequence.SequenceCache;
import org.hellojavaer.ddal.sequence.SequenceRange;
import org.hellojavaer.ddal.sequence.SequenceRangeGetter;
import org.hellojavaer.ddal.sequence.exception.GetSequenceTimeoutException;
import org.hellojavaer.ddal.sequence.exception.IllegalSequenceRangeException;
import org.hellojavaer.ddal.sequence.exception.NoAvailableSequenceRangeFoundException;
import org.hellojavaer.ddal.sequence.exception.SequenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSequence
implements Sequence {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_DELAY_RETRY_BASE_LINE = 4;
    private String schemaName;
    private String tableName;
    private Integer step;
    private Integer cacheNSteps;
    private Integer initTimeout;
    private SequenceRangeGetter sequenceRangeGetter;
    private ExceptionHandler exceptionHandler;
    private Integer delayRetryBaseLine = 4;
    private volatile SequenceCache sequenceCache;
    private boolean initialized = false;

    public SingleSequence() {
    }

    public SingleSequence(String schemaName, String tableName, Integer step, Integer cacheNSteps, Integer initTimeout, SequenceRangeGetter sequenceRangeGetter) {
        this(schemaName, tableName, step, cacheNSteps, initTimeout, sequenceRangeGetter, null, 4);
    }

    public SingleSequence(String schemaName, String tableName, Integer step, Integer cacheNSteps, Integer initTimeout, SequenceRangeGetter sequenceRangeGetter, ExceptionHandler exceptionHandler) {
        this(schemaName, tableName, step, cacheNSteps, initTimeout, sequenceRangeGetter, exceptionHandler, 4);
    }

    public SingleSequence(String schemaName, String tableName, Integer step, Integer cacheNSteps, Integer initTimeout, SequenceRangeGetter sequenceRangeGetter, ExceptionHandler exceptionHandler, Integer delayRetryBaseLine) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.step = step;
        this.cacheNSteps = cacheNSteps;
        this.initTimeout = initTimeout;
        this.sequenceRangeGetter = sequenceRangeGetter;
        this.exceptionHandler = exceptionHandler;
        this.delayRetryBaseLine = delayRetryBaseLine;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (!this.initialized) {
            SingleSequence singleSequence = this;
            synchronized (singleSequence) {
                if (!this.initialized) {
                    Assert.notNull((Object)this.schemaName, (String)"'schemaName' can't be null'");
                    Assert.notNull((Object)this.tableName, (String)"'tableName' can't be null'");
                    Assert.notNull((Object)this.step, (String)"'step' can't be null'");
                    Assert.isTrue((this.step > 0 ? 1 : 0) != 0, (String)"'step' must be greater than 0");
                    Assert.notNull((Object)this.cacheNSteps, (String)"'cacheNSteps' can't be null'");
                    Assert.isTrue((this.cacheNSteps > 0 ? 1 : 0) != 0, (String)"'cacheNSteps' must be greater than 0");
                    Assert.notNull((Object)this.initTimeout, (String)"'initTimeout' can't be null'");
                    Assert.isTrue((this.initTimeout > 0 ? 1 : 0) != 0, (String)"'initTimeout' must be greater than 0");
                    Assert.notNull((Object)this.sequenceRangeGetter, (String)"'sequenceRangeGetter' can't be null'");
                    Assert.notNull((Object)this.delayRetryBaseLine, (String)"'delayRetryBaseLine' can't be null'");
                    Assert.isTrue((this.delayRetryBaseLine > 0 ? 1 : 0) != 0, (String)"'delayRetryBaseLine' must be greater than 0");
                    try {
                        this.sequenceCache = new SequenceCache(this.step, this.cacheNSteps, this.initTimeout, this.exceptionHandler, this.delayRetryBaseLine){

                            @Override
                            public SequenceRange getSequenceRange() throws Exception {
                                SequenceRange sequenceRange = SingleSequence.this.getSequenceRangeGetter().get(SingleSequence.this.getSchemaName(), SingleSequence.this.getTableName(), SingleSequence.this.getStep());
                                if (sequenceRange == null) {
                                    throw new NoAvailableSequenceRangeFoundException("No available sequence rang was found for schemaName:'" + SingleSequence.this.getSchemaName() + "', tableName:'" + SingleSequence.this.getTableName() + "'");
                                }
                                if (sequenceRange.getBeginValue() > sequenceRange.getEndValue()) {
                                    throw new IllegalSequenceRangeException("Illegal sequence range " + sequenceRange + " for schemaName:'" + SingleSequence.this.getSchemaName() + "', tableName:'" + SingleSequence.this.getTableName() + "'");
                                }
                                return sequenceRange;
                            }
                        };
                    }
                    catch (InterruptedException e) {
                        throw new SequenceException(e);
                    }
                    catch (TimeoutException e) {
                        throw new GetSequenceTimeoutException(e);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public long nextValue(long timeout, TimeUnit timeUnit) throws GetSequenceTimeoutException {
        try {
            this.init();
            return this.sequenceCache.get(timeout, timeUnit);
        }
        catch (TimeoutException e1) {
            throw new GetSequenceTimeoutException(e1);
        }
        catch (SequenceException e0) {
            throw e0;
        }
        catch (Exception e) {
            throw new SequenceException(e);
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Integer getStep() {
        return this.step;
    }

    public void setStep(Integer step) {
        this.step = step;
    }

    public Integer getCacheNSteps() {
        return this.cacheNSteps;
    }

    public void setCacheNSteps(Integer cacheNSteps) {
        this.cacheNSteps = cacheNSteps;
    }

    public Integer getInitTimeout() {
        return this.initTimeout;
    }

    public void setInitTimeout(Integer initTimeout) {
        this.initTimeout = initTimeout;
    }

    public SequenceRangeGetter getSequenceRangeGetter() {
        return this.sequenceRangeGetter;
    }

    public void setSequenceRangeGetter(SequenceRangeGetter sequenceRangeGetter) {
        this.sequenceRangeGetter = sequenceRangeGetter;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Integer getDelayRetryBaseLine() {
        return this.delayRetryBaseLine;
    }

    public void setDelayRetryBaseLine(Integer delayRetryBaseLine) {
        this.delayRetryBaseLine = delayRetryBaseLine;
    }
}

