/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.sequence;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hellojavaer.ddal.sequence.ExceptionHandler;
import org.hellojavaer.ddal.sequence.SequenceRange;
import org.hellojavaer.ddal.sequence.SummedBlockingQueue;
import org.hellojavaer.ddal.sequence.exception.IllegalSequenceRangeException;
import org.hellojavaer.ddal.sequence.exception.NoAvailableSequenceRangeFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequenceCache {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SummedBlockingQueue summedBlockingQueue;
    private int step;
    private int cacheNSteps;
    private int initTimeout;
    private int delayRetryBaseLine;
    private ExceptionHandler exceptionHandler;
    private AtomicBoolean inited = new AtomicBoolean(false);
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private static AtomicInteger threadCount = new AtomicInteger(0);

    public SequenceCache(int step, int cacheNSteps, int initTimeout, ExceptionHandler exceptionHandler, int delayRetryBaseLine) throws InterruptedException, TimeoutException {
        if (step <= 0) {
            throw new IllegalArgumentException("step must be greater than 0");
        }
        if (cacheNSteps <= 0) {
            throw new IllegalArgumentException("cacheNSteps must be greater than 0");
        }
        this.step = step;
        this.cacheNSteps = cacheNSteps;
        this.initTimeout = initTimeout;
        this.exceptionHandler = exceptionHandler;
        this.summedBlockingQueue = new SummedBlockingQueue(step * cacheNSteps);
        this.delayRetryBaseLine = delayRetryBaseLine;
        this.startProducer();
        if (!this.countDownLatch.await(initTimeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException(initTimeout + " ms");
        }
    }

    public long get(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return this.summedBlockingQueue.get(timeout, timeUnit);
    }

    private void startProducer() {
        new Thread(SequenceCache.class.getSimpleName() + "-" + threadCount.getAndIncrement()){

            @Override
            public void run() {
                int[] sleepTimes = new int[]{100, 200, 300, 500, 800, 1300, 2100, 3000};
                int endCount = sleepTimes.length + SequenceCache.this.delayRetryBaseLine - 1;
                AtomicInteger retryCount = new AtomicInteger(0);
                while (true) {
                    if (Thread.interrupted()) break;
                    try {
                        SequenceRange range = SequenceCache.this.getSequenceRange();
                        if (range == null) {
                            throw new NoAvailableSequenceRangeFoundException("No available sequence range was found");
                        }
                        if (range.getBeginValue() > range.getEndValue()) {
                            throw new IllegalSequenceRangeException("Illegal sequence range " + range);
                        }
                        int c = (int)((range.getEndValue() - range.getBeginValue() + (long)SequenceCache.this.step) / (long)SequenceCache.this.step);
                        long beginValue = range.getBeginValue();
                        for (int i = 0; i < c; ++i) {
                            long endValue = beginValue + (long)SequenceCache.this.step - 1L;
                            endValue = endValue > range.getEndValue() ? range.getEndValue() : endValue;
                            SequenceCache.this.summedBlockingQueue.put(new SequenceRange(beginValue, endValue));
                            beginValue += (long)SequenceCache.this.step;
                            if (SequenceCache.this.inited.get() || SequenceCache.this.summedBlockingQueue.remainingSum() > 0L) continue;
                            SequenceCache.this.inited.set(true);
                            SequenceCache.this.countDownLatch.countDown();
                        }
                        retryCount.set(0);
                    }
                    catch (Throwable e) {
                        if (SequenceCache.this.exceptionHandler != null && SequenceCache.this.exceptionHandler.handle(e, retryCount)) continue;
                        if (e instanceof IllegalSequenceRangeException) {
                            SequenceCache.this.logger.error("[GetSequenceRange] " + e.getMessage());
                        } else if (e instanceof NoAvailableSequenceRangeFoundException) {
                            SequenceCache.this.logger.error("[GetSequenceRange] " + e.getMessage());
                        } else {
                            SequenceCache.this.logger.error("[GetSequenceRange]", e);
                        }
                        if (retryCount.get() >= SequenceCache.this.delayRetryBaseLine) {
                            try {
                                Thread.sleep(sleepTimes[retryCount.get() - SequenceCache.this.delayRetryBaseLine]);
                            }
                            catch (InterruptedException e1) {
                                SequenceCache.this.logger.error("[GetSequenceRange]", (Throwable)e1);
                            }
                        }
                        if (retryCount.get() >= endCount) continue;
                        retryCount.getAndIncrement();
                    }
                }
                SequenceCache.this.logger.error("[" + Thread.currentThread().getName() + " was interrupted]");
            }
        }.start();
    }

    public abstract SequenceRange getSequenceRange() throws Exception;
}

