/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.sequence;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.hellojavaer.ddal.sequence.SequenceRange;

class SummedBlockingQueue {
    private final AtomicInteger countForCapacity = new AtomicInteger(0);
    private transient Node head;
    private transient Node last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();
    private final long sum;
    private final AtomicLong countForSum = new AtomicLong(0L);
    private final ThreadLocal<InnerSequenceRange> threadLocal = new ThreadLocal();

    public SummedBlockingQueue(long sum) {
        this.sum = sum;
        this.last = this.head = new Node(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(SequenceRange sequenceRange) throws InterruptedException {
        if (sequenceRange.getEndValue() < sequenceRange.getBeginValue()) {
            throw new IllegalArgumentException("end value must be greater than or equal to begin value");
        }
        Node node = new Node(new InnerSequenceRange(sequenceRange.getBeginValue(), sequenceRange.getEndValue()));
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.countForCapacity;
        putLock.lockInterruptibly();
        long c = -1L;
        try {
            while (this.countForSum.get() >= this.sum) {
                this.notFull.await();
            }
            this.enqueue(node);
            c = count.incrementAndGet();
            long s = this.countForSum.addAndGet(sequenceRange.getEndValue() - sequenceRange.getBeginValue() + 1L);
            if (s < this.sum) {
                this.notFull.signal();
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 1L) {
            this.signalNotEmpty();
        }
    }

    public long get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("'timeout' must be greater then or equal to 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("'unit' can't be null");
        }
        InnerSequenceRange range = this.threadLocal.get();
        if (range != null) {
            long id = range.getCounter().getAndIncrement();
            if (id <= range.getEndValue()) {
                long c = this.countForSum.decrementAndGet();
                if (c == this.sum - 1L) {
                    this.signalNotFull();
                }
                if (id == range.getEndValue()) {
                    this.remove(range);
                    this.threadLocal.set(null);
                }
                return id;
            }
            this.remove(range);
            this.threadLocal.set(null);
            return this.recursiveGetFromQueue(timeout, unit);
        }
        return this.recursiveGetFromQueue(timeout, unit);
    }

    private long recursiveGetFromQueue(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        long now;
        long nanoTimeout = unit.toNanos(timeout);
        do {
            now = System.nanoTime();
            InnerSequenceRange sequenceRange = this.get(nanoTimeout);
            if (sequenceRange == null) {
                throw new TimeoutException(timeout + " " + (Object)((Object)unit));
            }
            long id = sequenceRange.getCounter().getAndIncrement();
            if (id <= sequenceRange.getEndValue()) {
                long c = this.countForSum.decrementAndGet();
                if (c == this.sum - 1L) {
                    this.signalNotFull();
                }
                if (id == sequenceRange.getEndValue()) {
                    this.remove(sequenceRange);
                } else {
                    this.threadLocal.set(sequenceRange);
                }
                return id;
            }
            this.remove(sequenceRange);
        } while ((nanoTimeout -= System.nanoTime() - now) > 0L);
        throw new TimeoutException(timeout + " " + (Object)((Object)unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InnerSequenceRange get(long nanoTimeout) throws InterruptedException {
        AtomicInteger count = this.countForCapacity;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        InnerSequenceRange x = null;
        try {
            while (count.get() == 0) {
                long now = System.nanoTime();
                if (nanoTimeout <= 0L) {
                    InnerSequenceRange innerSequenceRange = null;
                    return innerSequenceRange;
                }
                if (this.notEmpty.awaitNanos(nanoTimeout) <= 0L) {
                    InnerSequenceRange innerSequenceRange = null;
                    return innerSequenceRange;
                }
                nanoTimeout -= System.nanoTime() - now;
            }
            Node first = this.head.next;
            x = first == null ? null : first.item;
            if (count.get() > 0) {
                this.notEmpty.signal();
            }
        }
        finally {
            takeLock.unlock();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node trail = this.head;
            Node p = trail.next;
            while (p != null) {
                if (o.equals(p.item)) {
                    this.unlink(p, trail);
                    boolean bl = true;
                    return bl;
                }
                trail = p;
                p = p.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.fullyUnlock();
        }
    }

    void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    void unlink(Node p, Node trail) {
        p.item = null;
        trail.next = p.next;
        if (this.last == p) {
            this.last = trail;
        }
        this.countForCapacity.getAndDecrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            putLock.unlock();
        }
    }

    private void enqueue(Node node) {
        this.last = this.last.next = node;
    }

    public long remainingSum() {
        return this.sum - this.countForSum.get();
    }

    static class InnerSequenceRange {
        private final long beginValue;
        private final long endValue;
        private final AtomicLong counter;

        public InnerSequenceRange(long beginValue, long endValue) {
            this.beginValue = beginValue;
            this.endValue = endValue;
            this.counter = new AtomicLong(beginValue);
        }

        public long getBeginValue() {
            return this.beginValue;
        }

        public long getEndValue() {
            return this.endValue;
        }

        public AtomicLong getCounter() {
            return this.counter;
        }
    }

    static class Node {
        InnerSequenceRange item;
        Node next;

        Node(InnerSequenceRange x) {
            this.item = x;
        }
    }
}

