/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.sequence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ConcurrentModificationException;
import javax.sql.DataSource;
import org.hellojavaer.ddal.core.utils.Assert;
import org.hellojavaer.ddal.sequence.SequenceRange;
import org.hellojavaer.ddal.sequence.SequenceRangeGetter;
import org.hellojavaer.ddal.sequence.exception.IllegalSequenceRangeException;
import org.hellojavaer.ddal.sequence.exception.NoAvailableSequenceRangeFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSequenceRangeGetter
implements SequenceRangeGetter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String selectSqlTemplate = "SELECT %s, %s, %s, %s, %s, %s FROM %s.%s WHERE %s = ? AND %s = ? AND %s = 0 ORDER BY %s ASC LIMIT 1 ";
    private String updateSqlTemplate = "UPDATE %s.%s SET %s = ?, %s = ?, %s = %s + 1 WHERE %s = ? AND %s = ? LIMIT 1";
    private DataSource dataSource;
    private Connection connection;
    private String scName;
    private String tbName = "sequence";
    private String colNameOfPrimaryKey = "id";
    private String colNameOfSchemaName = "schema_name";
    private String colNameOfTableName = "table_name";
    private String colNameOfNextValue = "next_value";
    private String colNameOfEndValue = "end_value";
    private String colNameOfStep = "step";
    private String colNameOfSkipNSteps = "skip_n_steps";
    private String colNameOfSelectOrder = "select_order";
    private String colNameOfDeleted = "deleted";
    private String colNameOfVersion = "version";
    private volatile String targetSelectSql;
    private volatile String targetUpdateSql;
    private boolean initialized = false;

    public DatabaseSequenceRangeGetter() {
    }

    public DatabaseSequenceRangeGetter(DataSource dataSource, String scName) {
        this.dataSource = dataSource;
        this.scName = scName;
        this.init();
    }

    public DatabaseSequenceRangeGetter(DataSource dataSource, String scName, String tbName) {
        this.dataSource = dataSource;
        this.scName = scName;
        this.tbName = tbName;
        this.init();
    }

    public DatabaseSequenceRangeGetter(Connection connection, String scName) {
        this.connection = connection;
        this.scName = scName;
        this.init();
    }

    public DatabaseSequenceRangeGetter(Connection connection, String scName, String tbName) {
        this.connection = connection;
        this.scName = scName;
        this.tbName = tbName;
        this.init();
    }

    protected String getSelectSqlTemplate() {
        return this.selectSqlTemplate;
    }

    protected String getUpdateSqlTemplate() {
        return this.updateSqlTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (!this.initialized) {
            DatabaseSequenceRangeGetter databaseSequenceRangeGetter = this;
            synchronized (databaseSequenceRangeGetter) {
                if (!this.initialized) {
                    Assert.isTrue((this.dataSource != null && this.connection == null || this.dataSource == null && this.connection != null ? 1 : 0) != 0, (String)"'dataSource' and 'connection', only one of them should be configured");
                    Assert.notNull((Object)this.scName, (String)"'scName' can't be null");
                    Assert.notNull((Object)this.tbName, (String)"'tbName' can't be null");
                    Assert.notNull((Object)this.colNameOfPrimaryKey, (String)"'colNameOfPrimaryKey' can't be null");
                    Assert.notNull((Object)this.colNameOfSchemaName, (String)"'colNameOfSchemaName' can't be null");
                    Assert.notNull((Object)this.colNameOfTableName, (String)"'colNameOfTableName' can't be null");
                    Assert.notNull((Object)this.colNameOfNextValue, (String)"'colNameOfNextValue' can't be null");
                    Assert.notNull((Object)this.colNameOfEndValue, (String)"'colNameOfEndValue' can't be null");
                    Assert.notNull((Object)this.colNameOfStep, (String)"'colNameOfStep' can't be null");
                    Assert.notNull((Object)this.colNameOfSkipNSteps, (String)"'colNameOfSkipNSteps' can't be null");
                    Assert.notNull((Object)this.colNameOfSelectOrder, (String)"'colNameOfSelectOrder' can't be null");
                    Assert.notNull((Object)this.colNameOfDeleted, (String)"'colNameOfDeleted' can't be null");
                    Assert.notNull((Object)this.colNameOfVersion, (String)"'colNameOfVersion' can't be null");
                    this.targetSelectSql = String.format(this.getSelectSqlTemplate(), this.colNameOfPrimaryKey, this.colNameOfNextValue, this.colNameOfEndValue, this.colNameOfStep, this.colNameOfSkipNSteps, this.colNameOfVersion, this.scName, this.tbName, this.colNameOfSchemaName, this.colNameOfTableName, this.colNameOfDeleted, this.colNameOfSelectOrder);
                    this.targetUpdateSql = String.format(this.getUpdateSqlTemplate(), this.scName, this.tbName, this.colNameOfNextValue, this.colNameOfDeleted, this.colNameOfVersion, this.colNameOfVersion, this.colNameOfPrimaryKey, this.colNameOfVersion);
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public SequenceRange get(String schemaName, String tableName, int step) throws Exception {
        this.init();
        int rows = 0;
        Object sequenceRange = null;
        Connection connection = this.connection;
        PreparedStatement selectStatement = null;
        Statement updateStatement = null;
        boolean isNewConnection = false;
        if (connection == null || connection.isClosed()) {
            connection = this.dataSource.getConnection();
            isNewConnection = true;
            connection.setAutoCommit(false);
        }
        try {
            selectStatement = connection.prepareStatement(this.targetSelectSql);
            selectStatement.setString(1, schemaName);
            selectStatement.setString(2, tableName);
            ResultSet selectResult = selectStatement.executeQuery();
            long id = 0L;
            long nextValue = 0L;
            Long endValue = null;
            Integer dbStep = null;
            Integer skipNSteps = null;
            byte deleted = 0;
            long version = 0L;
            if (selectResult.next()) {
                Object skipNStepsObj;
                Object stepObj;
                id = ((Number)selectResult.getObject(1)).longValue();
                nextValue = selectResult.getLong(2);
                Object endValueObj = selectResult.getObject(3);
                if (endValueObj != null) {
                    endValue = ((Number)endValueObj).longValue();
                }
                if ((stepObj = selectResult.getObject(4)) != null) {
                    dbStep = ((Number)stepObj).intValue();
                }
                if ((skipNStepsObj = selectResult.getObject(5)) != null) {
                    skipNSteps = ((Number)skipNStepsObj).intValue();
                }
            } else {
                throw new NoAvailableSequenceRangeFoundException("No available sequence rang was found for schemaName:'" + schemaName + "', tableName:'" + tableName + "'");
            }
            version = selectResult.getLong(6);
            if (dbStep != null && dbStep > 0) {
                step = dbStep;
            }
            long rangeBegin = nextValue;
            long rangeEnd = nextValue + (long)step - 1L;
            if (endValue != null && rangeEnd > endValue) {
                rangeEnd = endValue;
            }
            updateStatement = connection.prepareStatement(this.targetUpdateSql);
            boolean dirtyRow = false;
            if (endValue != null && nextValue > endValue) {
                deleted = 1;
                dirtyRow = true;
            } else {
                nextValue = dbStep != null && dbStep > 0 && skipNSteps != null && skipNSteps > 0 ? (nextValue += (long)(step * (skipNSteps + 1))) : (nextValue += (long)step);
                if (endValue != null && nextValue > endValue) {
                    nextValue = endValue + 1L;
                    deleted = 1;
                }
            }
            updateStatement.setLong(1, nextValue);
            updateStatement.setByte(2, deleted);
            updateStatement.setLong(3, id);
            updateStatement.setLong(4, version);
            rows = updateStatement.executeUpdate();
            if (isNewConnection) {
                connection.commit();
            }
            if (rows > 0) {
                if (dirtyRow) {
                    throw new IllegalSequenceRangeException(String.format("Illegal sequence range {id:%s, nextValue:%s, endValue:%s, version:%s, deleted:0}", id, nextValue, endValue, version));
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("[Get_Range]: " + sequenceRange);
                }
                if (deleted == 1 && this.logger.isInfoEnabled()) {
                    this.logger.info("Sequence range for schemaName:{},tableName:{} is used up. More detail information is step:{},endValue:{},version:{},id:{} and actually allocated range is '{} ~ {}'", new Object[]{schemaName, tableName, step, endValue, version, id, rangeBegin, rangeEnd});
                }
                SequenceRange sequenceRange2 = new SequenceRange(rangeBegin, rangeEnd);
                return sequenceRange2;
            }
            throw new ConcurrentModificationException();
        }
        finally {
            if (selectStatement != null) {
                try {
                    selectStatement.close();
                }
                catch (Throwable e) {}
            }
            if (updateStatement != null) {
                try {
                    updateStatement.close();
                }
                catch (Throwable e) {}
            }
            if (isNewConnection && connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public String getTbName() {
        return this.tbName;
    }

    public void setTbName(String tbName) {
        this.tbName = tbName;
    }

    public String getColNameOfPrimaryKey() {
        return this.colNameOfPrimaryKey;
    }

    public void setColNameOfPrimaryKey(String colNameOfPrimaryKey) {
        this.colNameOfPrimaryKey = colNameOfPrimaryKey;
    }

    public String getColNameOfSchemaName() {
        return this.colNameOfSchemaName;
    }

    public void setColNameOfSchemaName(String colNameOfSchemaName) {
        this.colNameOfSchemaName = colNameOfSchemaName;
    }

    public String getColNameOfTableName() {
        return this.colNameOfTableName;
    }

    public void setColNameOfTableName(String colNameOfTableName) {
        this.colNameOfTableName = colNameOfTableName;
    }

    public String getColNameOfStep() {
        return this.colNameOfStep;
    }

    public void setColNameOfStep(String colNameOfStep) {
        this.colNameOfStep = colNameOfStep;
    }

    public String getColNameOfSkipNSteps() {
        return this.colNameOfSkipNSteps;
    }

    public void setColNameOfSkipNSteps(String colNameOfSkipNSteps) {
        this.colNameOfSkipNSteps = colNameOfSkipNSteps;
    }

    public String getColNameOfSelectOrder() {
        return this.colNameOfSelectOrder;
    }

    public void setColNameOfSelectOrder(String colNameOfSelectOrder) {
        this.colNameOfSelectOrder = colNameOfSelectOrder;
    }

    public String getColNameOfEndValue() {
        return this.colNameOfEndValue;
    }

    public void setColNameOfEndValue(String colNameOfEndValue) {
        this.colNameOfEndValue = colNameOfEndValue;
    }

    public String getColNameOfNextValue() {
        return this.colNameOfNextValue;
    }

    public void setColNameOfNextValue(String colNameOfNextValue) {
        this.colNameOfNextValue = colNameOfNextValue;
    }

    public String getColNameOfDeleted() {
        return this.colNameOfDeleted;
    }

    public void setColNameOfDeleted(String colNameOfDeleted) {
        this.colNameOfDeleted = colNameOfDeleted;
    }

    public String getColNameOfVersion() {
        return this.colNameOfVersion;
    }

    public void setColNameOfVersion(String colNameOfVersion) {
        this.colNameOfVersion = colNameOfVersion;
    }
}

