/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.sequence;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

class LinkedCycleList<T>
implements Iterable<T> {
    private final int size;
    private final AtomicReference<Node> point = new AtomicReference();

    public LinkedCycleList(T ... objs) {
        Node header;
        if (objs == null || objs.length == 0) {
            throw new IllegalArgumentException("objs can't be empty");
        }
        Node tail = header = new Node();
        for (T obj : objs) {
            Node node = new Node();
            node.setValue(obj);
            tail.setNext(node);
            tail = node;
        }
        tail.setNext(header.getNext());
        this.point.set(tail.getNext());
        this.size = objs.length;
    }

    public LinkedCycleList(Collection<T> collection) {
        Node header;
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("collection can't be empty");
        }
        Node tail = header = new Node();
        for (T obj : collection) {
            Node node = new Node();
            node.setValue(obj);
            tail.setNext(node);
            tail = node;
        }
        tail.setNext(header.getNext());
        this.point.set(tail.getNext());
        this.size = collection.size();
    }

    public T next() {
        Node next;
        Node node;
        if (this.size == 1) {
            return this.point.get().getValue();
        }
        while (!this.point.compareAndSet(node = this.point.get(), next = node.getNext())) {
        }
        return next.getValue();
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int count;
            private Node node;
            {
                this.count = LinkedCycleList.this.size;
                this.node = (Node)LinkedCycleList.this.point.get();
            }

            @Override
            public boolean hasNext() {
                return this.count > 0;
            }

            @Override
            public T next() {
                if (this.count <= 0) {
                    return null;
                }
                --this.count;
                Object value = this.node.getValue();
                this.node = this.node.getNext();
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private class Node {
        private Node next;
        private T value;

        private Node() {
        }

        public Node getNext() {
            return this.next;
        }

        public void setNext(Node next) {
            this.next = next;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

