/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.sequence;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hellojavaer.ddal.sequence.SequenceRange;
import org.hellojavaer.ddal.sequence.SequenceRangeGetter;
import org.hellojavaer.ddal.sequence.exception.GetSequenceFailedException;

public class HttpSequenceRangeGetter
implements SequenceRangeGetter {
    private String authorizeUrl;
    private String clientId;
    private String authorizeToken;
    private String accessToken;
    private String accessUrl;

    public HttpSequenceRangeGetter(String authorizeUrl, String clientId, String authorizeToken) {
        this.authorizeUrl = authorizeUrl;
        this.clientId = clientId;
        this.authorizeToken = authorizeToken;
        this.authorize();
    }

    @Override
    public SequenceRange get(String schemaName, String tableName, int step) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("clientId", this.clientId);
        param.put("accessToken", this.accessToken);
        param.put("schemaName", schemaName);
        param.put("tableName", tableName);
        param.put("step", String.valueOf(step));
        String result = HttpUtils.sendPost(this.accessUrl, param);
        Map<String, String> resultMap = this.parseHttpKvString(result);
        if (resultMap.isEmpty()) {
            return null;
        }
        if (resultMap.get("errorCode") != null) {
            this.authorize();
            result = HttpUtils.sendPost(this.accessUrl, param);
            resultMap = this.parseHttpKvString(result);
            if (resultMap.get("errorCode") != null) {
                throw new GetSequenceFailedException("clientId:" + this.clientId + " access data failed, return message is:" + result);
            }
        }
        SequenceRange sequenceRange = new SequenceRange();
        sequenceRange.setBeginValue(this.parseLong(resultMap.get("beginValue")));
        sequenceRange.setEndValue(this.parseLong(resultMap.get("endValue")));
        return sequenceRange;
    }

    private void authorize() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("clientId", this.clientId);
        param.put("authorizeToken", this.authorizeToken);
        String result = HttpUtils.sendPost(this.authorizeUrl, param);
        Map<String, String> resultMap = this.parseHttpKvString(result);
        if (resultMap.isEmpty()) {
            throw new GetSequenceFailedException("clientId:" + this.clientId + " authorize failed, return message is empty");
        }
        if (resultMap.get("errorCode") != null) {
            throw new GetSequenceFailedException("clientId:" + this.clientId + " authorize failed, return message is: " + result);
        }
        String accessUrl = resultMap.get("accessUrl");
        String accessToken = resultMap.get("accessToken");
        if (accessUrl == null || accessToken == null) {
            throw new GetSequenceFailedException("clientId:" + this.clientId + " authorize failed, accessUrl or accessToken is null, detail message is " + result);
        }
        try {
            accessUrl = URLDecoder.decode(accessUrl.trim(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GetSequenceFailedException(e);
        }
        this.accessUrl = accessUrl;
        this.accessToken = accessToken;
    }

    private Map<String, String> parseHttpKvString(String string) {
        String[] kvs;
        if (string == null) {
            return Collections.emptyMap();
        }
        if ((string = string.trim()).length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String kvString : kvs = string.split("&")) {
            String[] kv = kvString.split("=");
            if (kv.length == 2) {
                String val = kv[1];
                if ((val = val.trim()).length() == 0) {
                    val = null;
                }
                map.put(kv[0], val);
                continue;
            }
            if (kv.length == 1) {
                map.put(kv[0], null);
                continue;
            }
            throw new RuntimeException("Illegaled http kv string:" + kvString);
        }
        return map;
    }

    private Long parseLong(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        return Long.parseLong(str);
    }

    static class HttpUtils {
        private static final String USER_AGENT = "Mozilla/5.0";

        HttpUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String sendPost(String url, Map<String, String> params) {
            String string;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setDoOutput(true);
            DataOutputStream wr = null;
            try {
                wr = new DataOutputStream(con.getOutputStream());
                if (params != null && !params.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        sb.append(HttpUtils.encode(entry.getKey()));
                        sb.append('=');
                        sb.append(HttpUtils.encode(entry.getValue()));
                        sb.append('&');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    wr.write(sb.toString().getBytes("UTF-8"));
                }
                wr.flush();
            }
            catch (Throwable throwable) {
                HttpUtils.closeIO(wr);
                throw throwable;
            }
            HttpUtils.closeIO(wr);
            BufferedReader br = null;
            InputStream in = con.getResponseCode() < 400 ? con.getInputStream() : con.getErrorStream();
            try {
                String inputLine;
                br = new BufferedReader(new InputStreamReader(in));
                StringBuilder response = new StringBuilder();
                while ((inputLine = br.readLine()) != null) {
                    response.append(inputLine);
                    response.append('\n');
                }
                int responseCode = con.getResponseCode();
                if (responseCode != 200) {
                    throw new IllegalStateException("the requested url: " + url + " returned error code: " + responseCode + "\n" + response.toString());
                }
                string = response.toString();
            }
            catch (Throwable throwable) {
                try {
                    HttpUtils.closeIO(br);
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            HttpUtils.closeIO(br);
            return string;
        }

        private static String encode(String str) {
            if (str == null) {
                return "";
            }
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private static void closeIO(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

