/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.jsqlparser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.IntoTableVisitor;
import net.sf.jsqlparser.statement.select.Pivot;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.hellojavaer.ddal.ddr.datasource.exception.CrossingPreparedStatementException;
import org.hellojavaer.ddal.ddr.shard.RouteConfig;
import org.hellojavaer.ddal.ddr.shard.RouteInfo;
import org.hellojavaer.ddal.ddr.shard.ShardRouter;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParsedResult;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParsedState;
import org.hellojavaer.ddal.ddr.sqlparse.exception.AmbiguousRoutingResultException;
import org.hellojavaer.ddal.ddr.sqlparse.exception.GettingRoutInfoException;
import org.hellojavaer.ddal.ddr.sqlparse.exception.IllegalSQLParameterException;
import org.hellojavaer.ddal.ddr.sqlparse.exception.SQLSyntaxErrorException;
import org.hellojavaer.ddal.ddr.sqlparse.exception.UnsupportedSQLExpressionException;
import org.hellojavaer.ddal.ddr.sqlparse.exception.UnsupportedSQLParameterTypeException;
import org.hellojavaer.ddal.ddr.utils.DDRJSONUtils;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;
import org.hellojavaer.ddal.jsqlparser.utils.JSQLBaseVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSQLParserAdapter
extends JSQLBaseVisitor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String sql;
    private ShardRouter shardRouter;
    private Statement statement;
    private Set<String> schemas = new HashSet<String>();
    private List<TableWrapper> toBeConvertedTables = new ArrayList<TableWrapper>();
    private static final TableWrapper AMBIGUOUS_TABLE;
    private ThreadLocal<Stack<FrameContext>> context = new ThreadLocal<Stack<FrameContext>>(){

        @Override
        protected Stack<FrameContext> initialValue() {
            return new Stack<FrameContext>();
        }
    };

    private static void checkJSqlParserFeature() throws JSQLParserException {
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        String sql = "SELECT * FROM tab_1 WHERE tab_1.col_1 = ? AND col_2 IN (SELECT DISTINCT col_2 FROM tab_2 WHERE col_3 LIKE ? AND col_4 > ?) LIMIT ?, ?";
        Select select = (Select)parserManager.parse((Reader)new StringReader(sql));
        PlainSelect selectBody = (PlainSelect)select.getSelectBody();
        AndExpression andExpression = (AndExpression)selectBody.getWhere();
        EqualsTo equalsTo = (EqualsTo)andExpression.getLeftExpression();
        JdbcParameter jdbcParameter = (JdbcParameter)equalsTo.getRightExpression();
        Integer index1 = jdbcParameter.getIndex();
        if (index1 != 1) {
            throw new IllegalStateException();
        }
        InExpression inExpression = (InExpression)andExpression.getRightExpression();
        SubSelect subSelect = (SubSelect)inExpression.getRightItemsList();
        PlainSelect subSelectBody = (PlainSelect)subSelect.getSelectBody();
        AndExpression subAndExpression = (AndExpression)subSelectBody.getWhere();
        LikeExpression likeExpression = (LikeExpression)subAndExpression.getLeftExpression();
        if (((JdbcParameter)likeExpression.getRightExpression()).getIndex() != 2) {
            throw new IllegalStateException();
        }
        GreaterThan greaterThan = (GreaterThan)subAndExpression.getRightExpression();
        if (((JdbcParameter)greaterThan.getRightExpression()).getIndex() != 3) {
            throw new IllegalStateException();
        }
        Expression offset = selectBody.getLimit().getOffset();
        Expression rowCount = selectBody.getLimit().getRowCount();
        if (((JdbcParameter)offset).getIndex() != 4 || ((JdbcParameter)rowCount).getIndex() != 5) {
            throw new IllegalStateException();
        }
    }

    public JSQLParserAdapter(String sql, ShardRouter shardRouter) {
        this.sql = sql;
        this.shardRouter = shardRouter;
        try {
            this.statement = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            throw new SQLSyntaxErrorException("sql is [" + sql + "]", e);
        }
        if (!(this.statement instanceof Select || this.statement instanceof Update || this.statement instanceof Insert || this.statement instanceof Delete)) {
            throw new UnsupportedSQLExpressionException("Sql [" + sql + "] is not supported in shard sql. Only support 'select' 'insert' 'update' and 'delete' sql statement");
        }
    }

    private String generateSplitString(String str) {
        long l;
        String tar;
        Random random = new Random(System.currentTimeMillis());
        do {
            if ((l = random.nextLong()) >= 0L) continue;
            l = -l;
        } while (str.indexOf(tar = "__" + l) >= 0);
        return tar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLParsedState parse() {
        try {
            SQLParsedState parsedResult;
            this.statement.accept((StatementVisitor)this);
            String targetSql = this.statement.toString();
            String splitString = this.generateSplitString(targetSql);
            for (int i = 0; i < this.toBeConvertedTables.size(); ++i) {
                TableWrapper tab = this.toBeConvertedTables.get(i);
                tab.setSchemaName(null);
                tab.setName("_" + i + splitString);
            }
            targetSql = this.statement.toString();
            final ArrayList<Object> splitSqls = new ArrayList<Object>();
            String[] sqls = targetSql.split(splitString);
            for (int i = 0; i < sqls.length - 1; ++i) {
                String s = sqls[i];
                int index = s.lastIndexOf(95);
                splitSqls.add(s.substring(0, index));
                Integer paramIndex = Integer.valueOf(s.substring(index + 1));
                splitSqls.add((Object)this.toBeConvertedTables.get(paramIndex));
            }
            splitSqls.add(sqls[sqls.length - 1]);
            SQLParsedState sQLParsedState = parsedResult = new SQLParsedState(){

                public SQLParsedResult parse(final Map<Object, Object> jdbcParams) {
                    final HashMap<TableWrapper, String> convertedTables = new HashMap<TableWrapper, String>();
                    HashSet<String> schemas = new HashSet<String>(JSQLParserAdapter.this.schemas);
                    SQLParsedResult result = new SQLParsedResult(){

                        public void checkIfCrossPreparedStatement(Map<Object, Object> jdbcParam) throws CrossingPreparedStatementException {
                            for (Map.Entry entry : convertedTables.entrySet()) {
                                TableWrapper tab = (TableWrapper)((Object)entry.getKey());
                                JSQLParserAdapter.this.route1(tab, jdbcParams, (String)entry.getValue(), this.getSql());
                            }
                        }
                    };
                    StringBuilder sb = new StringBuilder();
                    for (Object obj : splitSqls) {
                        if (obj instanceof TableWrapper) {
                            TableWrapper tab = (TableWrapper)((Object)obj);
                            RouteInfo routeInfo = JSQLParserAdapter.this.route1(tab, jdbcParams, tab.getRoutedFullTableName(), null);
                            schemas.add(routeInfo.getScName());
                            String routedFullTableName = routeInfo.toString();
                            convertedTables.put(tab, routedFullTableName);
                            sb.append(routedFullTableName);
                            continue;
                        }
                        sb.append(obj);
                    }
                    result.setSql(sb.toString());
                    result.setSchemas(schemas);
                    return result;
                }
            };
            return sQLParsedState;
        }
        finally {
            this.getStack().clear();
        }
    }

    private RouteInfo route1(TableWrapper tab, Map<Object, Object> jdbcParams, String routedFullTableName, String routedSql) {
        RouteInfo routeInfo = null;
        if (tab.getJdbcParamKeys() == null || tab.getJdbcParamKeys().isEmpty()) {
            routeInfo = this.getRouteInfo(tab, null);
            if (routeInfo != null) {
                String fullTableName = routeInfo.toString();
                if (tab.getRoutedFullTableName() != null && !tab.getRoutedFullTableName().equals(fullTableName)) {
                    throw new AmbiguousRoutingResultException("In sql[" + this.sql + "], table:'" + tab.getOriginalConfig().toString() + "' has multiple routing results[" + tab.getRoutedFullTableName() + "," + fullTableName + "]");
                }
            } else {
                throw new GettingRoutInfoException("Can't get route information for table:'" + tab.getOriginalConfig().toString() + "' 'sdValue':null and 'routeConfig':" + tab.getRouteConfig().toString());
            }
            return routeInfo;
        }
        for (Object sqlParam : tab.getJdbcParamKeys()) {
            Number number;
            if (sqlParam instanceof SqlParam) {
                Object sdValue = null;
                Object key = ((SqlParam)sqlParam).getValue();
                if (jdbcParams != null) {
                    sdValue = jdbcParams.get(key);
                }
                if (sdValue == null) {
                    throw new IllegalSQLParameterException("For jdbc parameter key " + key + ", jdbc parameter value is null. Jdbc parameter map is " + DDRJSONUtils.toJSONString(jdbcParams) + " and sql is [" + this.sql + "]");
                }
                routeInfo = this.getRouteInfo(tab, sdValue);
                String next = routeInfo.toString();
                if (routedFullTableName == null) {
                    routedFullTableName = next;
                    continue;
                }
                if (routedFullTableName.equals(next)) continue;
                throw new AmbiguousRoutingResultException("In sql[" + this.sql + "], table:'" + tab.getOriginalConfig().toString() + "' has multiple routing results[" + routedFullTableName + "," + next + "]. Jdbc parameter is " + DDRJSONUtils.toJSONString(jdbcParams));
            }
            RangeParam rangeParam = (RangeParam)sqlParam;
            SqlParam begin = rangeParam.getBeginValue();
            SqlParam end = rangeParam.getEndValue();
            long s0 = 0L;
            long e0 = 0L;
            if (begin.isJdbcParamType()) {
                number = (Number)jdbcParams.get(begin.getValue());
                if (number == null) {
                    throw new IllegalSQLParameterException("Jdbc parameter can't be null. Jdbc parameter key is " + begin.getValue() + ", jdbc parameter is " + DDRJSONUtils.toJSONString(jdbcParams) + " and sql is [" + this.sql + "]");
                }
                s0 = number.longValue();
            } else {
                s0 = ((Number)begin.getValue()).longValue();
            }
            if (end.isJdbcParamType()) {
                number = (Number)jdbcParams.get(end.getValue());
                if (number == null) {
                    // empty if block
                }
                e0 = number.longValue();
            } else {
                e0 = ((Number)end.getValue()).longValue();
            }
            if (s0 > e0) {
                long temp = s0;
                s0 = e0;
                e0 = temp;
            }
            for (long l = s0; l <= e0; ++l) {
                routeInfo = this.getRouteInfo(tab, l);
                String next = routeInfo.toString();
                if (routedFullTableName == null) {
                    routedFullTableName = next;
                    continue;
                }
                if (routedFullTableName.equals(next)) continue;
                if (routedSql != null) {
                    throw new CrossingPreparedStatementException("Sql[" + this.sql + "] has been routed to [" + routedSql + "] and table:'" + tab.getOriginalConfig().toString() + "' has been route to '" + routedFullTableName + "'. But current jdbc parameter:" + DDRJSONUtils.toJSONString(jdbcParams) + " require route to " + next + DDRJSONUtils.toJSONString(jdbcParams));
                }
                throw new AmbiguousRoutingResultException("In sql[" + this.sql + "], table:'" + tab.getOriginalConfig().toString() + "' has multiple routing results[" + routedFullTableName + "," + next + "]. Jdbc parameter is " + DDRJSONUtils.toJSONString(jdbcParams));
            }
        }
        return routeInfo;
    }

    private void afterVisitBaseStatement() {
        FrameContext context = this.getStack().pop();
        for (Map.Entry entry : context.entrySet()) {
            TableWrapper tab = (TableWrapper)((Object)entry.getValue());
            if (tab == AMBIGUOUS_TABLE) continue;
            if (tab.getJdbcParamKeys() != null && !tab.getJdbcParamKeys().isEmpty()) {
                this.toBeConvertedTables.add(tab);
                continue;
            }
            if (tab.getRoutedFullTableName() != null) continue;
            this.toBeConvertedTables.add(tab);
        }
    }

    private RouteInfo getRouteInfo(TableWrapper tab, Object sdValue) {
        try {
            RouteInfo routeInfo = this.shardRouter.route(tab.getOriginalConfig().getSchemaName(), tab.getOriginalConfig().getName(), sdValue);
            return routeInfo;
        }
        catch (Throwable e) {
            String fullTableName = null;
            fullTableName = tab.getOriginalConfig().getAlias() != null ? tab.getOriginalConfig().getAlias().getName() : tab.getOriginalConfig().getName();
            String sdKey = null;
            if (tab.getRouteConfig().getSdKey() != null) {
                sdKey = fullTableName + "." + tab.getRouteConfig().getSdKey();
            }
            String msg = String.format("Current state is table:'%s', sdKey:'%s', sdValue:%s, routeConfig:%s, sql:[%s]", tab.getOriginalConfig().toString(), sdKey, sdValue, tab.getRouteConfig().toString(), this.sql);
            throw new GettingRoutInfoException(msg, e);
        }
    }

    private void route0(TableWrapper tab, RouteInfo routeInfo) {
        String fullTableName = routeInfo.toString();
        if (tab.getRoutedFullTableName() != null) {
            if (!tab.getRoutedFullTableName().equals(fullTableName)) {
                throw new AmbiguousRoutingResultException("In sql[" + this.sql + "], table:'" + tab.getOriginalConfig().toString() + "' has multiple routing results[" + tab.getRoutedFullTableName() + "," + fullTableName + "]");
            }
        } else {
            tab.setRoutedFullTableName(fullTableName);
            tab.setSchemaName(routeInfo.getScName());
            tab.setName(routeInfo.getTbName());
            this.schemas.add(routeInfo.getScName());
        }
    }

    @Override
    public void visit(Insert insert) {
        this.getStack().push(new FrameContext());
        RouteConfig routeConfig = this.shardRouter.getRouteConfig(insert.getTable().getSchemaName(), insert.getTable().getName());
        if (routeConfig != null) {
            TableWrapper table = new TableWrapper(insert.getTable(), routeConfig);
            this.addRoutedTableIntoContext(table, routeConfig, false);
            List columns = insert.getColumns();
            if (columns != null) {
                ExpressionList expressionList = (ExpressionList)insert.getItemsList();
                List valueList = expressionList.getExpressions();
                for (int i = 0; i < columns.size(); ++i) {
                    Column column = (Column)columns.get(i);
                    TableWrapper tab = this.getTableFromContext(column);
                    if (tab == null) continue;
                    Expression expression = (Expression)valueList.get(i);
                    this.routeTable(tab, column, expression);
                }
            }
        }
        super.visit(insert);
        this.afterVisitBaseStatement();
    }

    @Override
    public void visit(Delete delete) {
        this.getStack().push(new FrameContext());
        RouteConfig routeConfig = this.shardRouter.getRouteConfig(delete.getTable().getSchemaName(), delete.getTable().getName());
        if (routeConfig != null) {
            TableWrapper tab = new TableWrapper(delete.getTable(), routeConfig);
            delete.setTable((Table)tab);
            this.addRoutedTableIntoContext(tab, routeConfig, false);
        }
        super.visit(delete);
        this.afterVisitBaseStatement();
    }

    @Override
    public void visit(Update update) {
        this.getStack().push(new FrameContext());
        if (update.getTables() != null) {
            for (Table table : update.getTables()) {
                RouteConfig routeConfig = this.shardRouter.getRouteConfig(table.getSchemaName(), table.getName());
                if (routeConfig == null) continue;
                TableWrapper tab = new TableWrapper(table, routeConfig);
                this.addRoutedTableIntoContext(tab, routeConfig, true);
            }
        }
        super.visit(update);
        this.afterVisitBaseStatement();
    }

    @Override
    public void visit(Select select) {
        this.getStack().push(new FrameContext());
        super.visit(select);
        this.afterVisitBaseStatement();
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.getStack().push(new FrameContext());
        super.visit(subSelect);
        this.afterVisitBaseStatement();
    }

    private TableWrapper getTableFromContext(Column col) {
        FrameContext frameContext = this.getStack().peek();
        String colFullName = col.toString();
        colFullName = DDRStringUtils.toLowerCase((String)colFullName);
        return (TableWrapper)((Object)frameContext.get(colFullName));
    }

    private void addRoutedTableIntoContext(TableWrapper table, RouteConfig routeInfo) {
        this.addRoutedTableIntoContext(table, routeInfo, true);
    }

    private void addRoutedTableIntoContext(TableWrapper table, RouteConfig routeConfig, boolean appendAlias) {
        String tbName;
        FrameContext frameContext = this.getStack().peek();
        String tbAliasName = tbName = table.getName();
        if (table.getAlias() != null && table.getAlias().getName() != null) {
            tbAliasName = table.getAlias().getName();
        } else if (appendAlias) {
            table.setAlias(new Alias(tbName, true));
        }
        String sdKey = DDRStringUtils.toLowerCase((String)routeConfig.getSdKey());
        if (table.getSchemaName() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(DDRStringUtils.toLowerCase((String)table.getSchemaName()));
            sb.append('.');
            sb.append(DDRStringUtils.toLowerCase((String)tbAliasName));
            sb.append('.');
            sb.append(sdKey);
            String key = sb.toString();
            this.putIntoContext(frameContext, key, table);
            this.putIntoContext(frameContext, key.substring(table.getSchemaName().length() + 1), table);
            this.putIntoContext(frameContext, key.substring(table.getSchemaName().length() + 2 + tbAliasName.length()), table);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(DDRStringUtils.toLowerCase((String)tbAliasName));
            sb.append('.');
            sb.append(sdKey);
            String key = sb.toString();
            this.putIntoContext(frameContext, key, table);
            this.putIntoContext(frameContext, key.substring(tbAliasName.length() + 1), table);
        }
    }

    private Object getRouteValue(Column column, Expression obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LongValue) {
            return ((LongValue)obj).getValue();
        }
        if (obj instanceof StringValue) {
            return ((StringValue)obj).getValue();
        }
        if (obj instanceof HexValue) {
            return Long.parseLong(((HexValue)obj).getValue(), 16);
        }
        if (obj instanceof DateValue) {
            return ((DateValue)obj).getValue();
        }
        if (obj instanceof DoubleValue) {
            return ((DoubleValue)obj).getValue();
        }
        if (obj instanceof TimeValue) {
            return ((TimeValue)obj).getValue();
        }
        if (obj instanceof TimestampValue) {
            return ((TimestampValue)obj).getValue();
        }
        throw new UnsupportedSQLParameterTypeException("Type '" + obj.getClass() + "' is not supported for shard value '" + column.toString() + "'. Sql is [" + this.sql + "]");
    }

    @Override
    public void visit(InExpression inExpression) {
        if (inExpression.isNot()) {
            super.visit(inExpression);
            return;
        }
        Column column = (Column)inExpression.getLeftExpression();
        if (inExpression.getRightItemsList() instanceof ExpressionList) {
            TableWrapper tab = this.getTableFromContext(column);
            if (tab == null) {
                super.visit(inExpression);
                return;
            }
            ExpressionList itemsList = (ExpressionList)inExpression.getRightItemsList();
            List list = itemsList.getExpressions();
            if (list == null || list.isEmpty()) {
                super.visit(inExpression);
            }
            for (Expression exp : list) {
                this.routeTable(tab, column, exp);
            }
        } else {
            super.visit(inExpression);
            return;
        }
    }

    @Override
    public void visit(Between between) {
        long e1;
        if (between.isNot()) {
            super.visit(between);
            return;
        }
        Column column = (Column)between.getLeftExpression();
        TableWrapper tab = this.getTableFromContext(column);
        if (tab == null) {
            super.visit(between);
            return;
        }
        Expression begin = between.getBetweenExpressionStart();
        Expression end = between.getBetweenExpressionEnd();
        if (begin instanceof SubSelect || end instanceof SubSelect) {
            super.visit(between);
            return;
        }
        if (begin instanceof JdbcParameter || begin instanceof JdbcNamedParameter || end instanceof JdbcParameter || end instanceof JdbcNamedParameter) {
            tab.getJdbcParamKeys().add(new RangeParam(new SqlParam(column, begin), new SqlParam(column, end)));
            return;
        }
        long s1 = ((Number)this.getRouteValue(column, begin)).longValue();
        if (s1 > (e1 = ((Number)this.getRouteValue(column, end)).longValue())) {
            long temp = s1;
            s1 = e1;
            e1 = temp;
        }
        for (long l = s1; l <= e1; ++l) {
            this.routeTable(tab, column, l);
        }
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        Column column = (Column)equalsTo.getLeftExpression();
        if (equalsTo.getRightExpression() instanceof SubSelect) {
            super.visit(equalsTo);
            return;
        }
        String fullColumnName = column.toString();
        fullColumnName = DDRStringUtils.toLowerCase((String)fullColumnName);
        TableWrapper tab = (TableWrapper)((Object)this.getStack().peek().get(fullColumnName));
        if (tab != null) {
            this.routeTable(tab, column, equalsTo.getRightExpression());
        } else {
            super.visit(equalsTo);
        }
    }

    private void routeTable(TableWrapper tab, Column column, Expression routeValueExpression) {
        if (routeValueExpression != null && routeValueExpression instanceof JdbcParameter || routeValueExpression instanceof JdbcNamedParameter) {
            tab.getJdbcParamKeys().add(new SqlParam(column, routeValueExpression));
            return;
        }
        Object sdValue = this.getRouteValue(column, routeValueExpression);
        this.routeTable(tab, column, sdValue);
    }

    private void routeTable(TableWrapper tab, Column column, Object sdValue) {
        if (tab == null) {
            return;
        }
        if (tab == AMBIGUOUS_TABLE) {
            throw new RuntimeException("Shard value '" + column.toString() + "' in where clause is ambiguous. Sql is [" + this.sql + "]");
        }
        RouteInfo routeInfo = this.getRouteInfo(tab, sdValue);
        this.route0(tab, routeInfo);
    }

    @Override
    public void visit(Table table) {
        String tbName = table.getName();
        RouteConfig routeConfig = this.shardRouter.getRouteConfig(table.getSchemaName(), tbName);
        if (routeConfig != null) {
            TableWrapper tab = new TableWrapper(table, routeConfig);
            this.addRoutedTableIntoContext(tab, routeConfig);
        }
    }

    private void putIntoContext(FrameContext frameContext, String key, TableWrapper tab) {
        TableWrapper tab0 = (TableWrapper)((Object)frameContext.get(key));
        if (tab0 == null) {
            frameContext.put(key, tab);
        } else {
            frameContext.put(key, AMBIGUOUS_TABLE);
        }
    }

    private Stack<FrameContext> getStack() {
        return this.context.get();
    }

    static {
        try {
            JSQLParserAdapter.checkJSqlParserFeature();
        }
        catch (Exception e) {
            throw new RuntimeException("JSqlParser feature check failed", e);
        }
        AMBIGUOUS_TABLE = new TableWrapper(null, null);
    }

    private class SqlParam {
        private Column column;
        private Expression expression;
        private Object value;
        private boolean jdbcParamType = false;

        public SqlParam(Column column, Expression expression) {
            this.column = column;
            this.expression = expression;
            if (expression instanceof JdbcParameter) {
                this.value = ((JdbcParameter)expression).getIndex();
                this.jdbcParamType = true;
            } else if (expression instanceof JdbcNamedParameter) {
                this.value = ((JdbcNamedParameter)expression).getName();
                this.jdbcParamType = true;
            } else {
                this.value = JSQLParserAdapter.this.getRouteValue(column, expression);
                this.jdbcParamType = false;
            }
        }

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isJdbcParamType() {
            return this.jdbcParamType;
        }

        public void setJdbcParamType(boolean jdbcParamType) {
            this.jdbcParamType = jdbcParamType;
        }
    }

    private class RangeParam {
        private SqlParam beginValue;
        private SqlParam endValue;

        public RangeParam(SqlParam beginValue, SqlParam endValue) {
            this.beginValue = beginValue;
            this.endValue = endValue;
        }

        public SqlParam getBeginValue() {
            return this.beginValue;
        }

        public void setBeginValue(SqlParam beginValue) {
            this.beginValue = beginValue;
        }

        public SqlParam getEndValue() {
            return this.endValue;
        }

        public void setEndValue(SqlParam endValue) {
            this.endValue = endValue;
        }
    }

    private static class TableWrapper
    extends Table {
        private Table table;
        private Table originalConfig = new Table();
        private RouteConfig routeConfig;
        private String routedFullTableName;
        private List<Object> jdbcParamKeys = new ArrayList<Object>();

        public TableWrapper(Table table, RouteConfig routeConfig) {
            this.routeConfig = routeConfig;
            if (table != null) {
                this.table = table;
                this.originalConfig.setDatabase(table.getDatabase());
                this.originalConfig.setSchemaName(table.getSchemaName());
                this.originalConfig.setName(table.getName());
                this.originalConfig.setAlias(table.getAlias());
                this.originalConfig.setPivot(table.getPivot());
                this.originalConfig.setASTNode(table.getASTNode());
            }
        }

        public RouteConfig getRouteConfig() {
            return this.routeConfig;
        }

        public void setRouteConfig(RouteConfig routeConfig) {
            this.routeConfig = routeConfig;
        }

        public String getRoutedFullTableName() {
            return this.routedFullTableName;
        }

        public void setRoutedFullTableName(String routedFullTableName) {
            this.routedFullTableName = routedFullTableName;
        }

        public List<Object> getJdbcParamKeys() {
            return this.jdbcParamKeys;
        }

        public void setJdbcParamKeys(List<Object> jdbcParamKeys) {
            this.jdbcParamKeys = jdbcParamKeys;
        }

        public Table getOriginalConfig() {
            return this.originalConfig;
        }

        public void setOriginalConfig(Table originalConfig) {
            this.originalConfig = originalConfig;
        }

        public Database getDatabase() {
            return this.table.getDatabase();
        }

        public void setDatabase(Database database) {
            this.table.setDatabase(database);
        }

        public String getSchemaName() {
            return this.table.getSchemaName();
        }

        public void setSchemaName(String string) {
            this.table.setSchemaName(string);
        }

        public String getName() {
            return this.table.getName();
        }

        public void setName(String string) {
            this.table.setName(string);
        }

        public Alias getAlias() {
            return this.table.getAlias();
        }

        public void setAlias(Alias alias) {
            this.table.setAlias(alias);
        }

        public String getFullyQualifiedName() {
            return this.table.getFullyQualifiedName();
        }

        public void accept(FromItemVisitor fromItemVisitor) {
            this.table.accept(fromItemVisitor);
        }

        public void accept(IntoTableVisitor intoTableVisitor) {
            this.table.accept(intoTableVisitor);
        }

        public Pivot getPivot() {
            return this.table.getPivot();
        }

        public void setPivot(Pivot pivot) {
            this.table.setPivot(pivot);
        }
    }

    private class FrameContext
    extends HashMap<String, TableWrapper> {
        private FrameContext() {
        }
    }
}

